% FIGURE10.M
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% Monthly data
time=1978+1/12:1/12:2016+3/12;
load currentvehicle.txt;      % MSC Current buying conditions for vehciles
load autosandlighttrucks.txt; % BEA, SA, millions, excludes heavy trucks

subplot(2,1,1)
plot(time,autosandlighttrucks,'b-',time,autosandlighttrucks(438)*ones(size(time)),'k-','linewidth',3)
ylabel('Millions','fontsize',18)
title('Sales of Autos and Light Trucks (BEA)','fontsize',18)
axis([2014+5/12 time(end) 16 18.5])
grid on
line([(2014+6/12) (2014+6/12)], [-5000 5000],'linewidth',2)
line([(2015+1/12) (2015+1/12)], [-5000 5000],'linewidth',2)
set(gca,'XTick',[2014 2015 2016])

subplot(2,1,2)
plot(time,currentvehicle,'b-',time,currentvehicle(438)*ones(size(time)),'k-','linewidth',3)
ylabel('Index','fontsize',18)
title('Current Buying Conditions for Vehicles (Michigan Survey of Consumers)','fontsize',18)
axis([2014+5/12 time(end) 125 160])
grid on
line([(2014+6/12) (2014+6/12)], [-5000 5000],'linewidth',2)
line([(2015+1/12) (2015+1/12)], [-5000 5000],'linewidth',2)
set(gca,'XTick',[2014 2015 2016])

