% FIGURE1.M
% in: Baumeister, C. and L. Kilian, "Lower Oil Prices and the U.S. 
%     Economy: Is This Time Different?" Brookings Papers on Economic
%     Activity, Fall 2016

clear;
clc;

% Monthly, 2000.1-2016.3
%1 Rail Freight Carloads: ton miles	
%2 Truck Tonnage: index
%3 Air Revenue Passenger Miles: thousands 	

time=2000+1/12:1/12:2016+3/12;
load transport.txt;

for j=1:3
    transport(:,j)=(transport(:,j)./transport(174,j))*100;
end;

plot(time,transport(:,1),'r-.','linewidth',3), hold on, ...
    plot(time,transport(:,2),'b','linewidth',3), hold on, ...
    plot(time,transport(:,3),'k:','linewidth',3)
line([(2014+6/12) (2014+6/12)], [0.5*100 1.5*100],'linewidth',2)
axis([2013 time(end) 0.7*100 1.3*100])
legend('Rail Freight','Truck Freight','Air Revenue Passenger Miles')
ylabel('Percent','fontsize',18)
grid on
set(gca,'XTick',[2011+5/12 2016+5/12])
text(2012,67,'2012','hor','center','fontsize',12)
text(2013,67,'2013','hor','center','fontsize',12)
text(2014,67,'2014','hor','center','fontsize',12)
text(2015,67,'2015','hor','center','fontsize',12)
text(2016,67,'2016','hor','center','fontsize',12)

