clear all
capture log close
program drop _all
set more off

clear

*** Preparing t-test Significance Table
*** John W. McArthur and Krista Rasmussen
*** January 2017
*** [Program by Brina Seidel]

*************************************************
*************************************************
*** Define programs
*************************************************
*************************************************

***************************************
*** Define a program to export ttest results
***		`1' = post variable
***		`2' = pre variable
***		`3' = column for export
***************************************

program define EXPORT_TTEST
	
	ttest `1' == `2'

	*** Get mean difference
	local mean = round(100*(r(mu_1) - r(mu_2)), .01)

	*** Add significance stars
	if r(p) < .01 {
		local mean = "`mean'" + "***" 
	}
	else if r(p) < .05 {
		local mean = "`mean'" + "**" 
	}
	else if r(p) < .1 {
		local mean = "`mean'" + "*" 
	}

	*** Confirm that this was done correctly
	disp ""
	disp "Mean to export: `mean'" _col(30) "(p value was " %8.4f r(p) ")"
	
	putexcel `3'$row_num = "`mean'"
	
	sleep 200 
	
end 
	
***************************************
*** Define a program to get ttest results for all four categories
***		`1' = post variable
***		`2' = pre variable
***		`3' = file name
***************************************
program define GET_TTESTS

	use "`3'.dta", clear
	
	*** Export file name as a row label
	putexcel A$row_num = "`3'"
	
	*** All
	assert IncomeGroup != "H"
	EXPORT_TTEST `1' `2' "B"
	
	*** LIC
	preserve
	keep if IncomeGroup == "L"
	EXPORT_TTEST `1' `2' "C"
	restore
	
	*** MIC
	preserve
	keep if IncomeGroup != "L"
	EXPORT_TTEST `1' `2' "D"
	restore
	
	*** SSA
	preserve
	keep if Region == "SSA"
	EXPORT_TTEST `1' `2' "E"
	restore

	*** EAP
	preserve
	keep if Region == "EAP"
	EXPORT_TTEST `1' `2' "F"
	restore

	*** ECA
	preserve
	keep if Region == "ECA"
	EXPORT_TTEST `1' `2' "G"
	restore

	*** LAC
	preserve
	keep if Region == "LAC"
	EXPORT_TTEST `1' `2' "H"
	restore
	
	*** MENA
	preserve
	keep if Region == "MENA"
	EXPORT_TTEST `1' `2' "I"
	restore

	*** SA
	preserve
	keep if Region == "SA"
	EXPORT_TTEST `1' `2' "J"
	restore
	
	global row_num = $row_num + 1
	
end
*************************************************
*************************************************
*** Set up excel file
*************************************************
*************************************************

putexcel set "T-test Significance Table.xlsx", replace
putexcel A1 = "Indicator"
putexcel B1 = "All"
putexcel C1 = "LIC"
putexcel D1 = "MIC"
putexcel E1 = "SSA"
putexcel F1 = "EAP"
putexcel G1 = "ECA"
putexcel H1 = "LAC"
putexcel I1 = "MENA"
putexcel J1 = "SA"

*************************************************
*************************************************
*** Calculate and export results
*************************************************
*************************************************

global row_num = 2

GET_TTESTS rp0015 rp9000 "u5mr_analysis"
GET_TTESTS rp0115 rp9601 "u5mr_analysis"
GET_TTESTS rp0015 rp9000 "maternal_mort_modeled_analysis"
GET_TTESTS rp0115 rp9601 "maternal_mort_modeled_analysis"
GET_TTESTS rp0215 rp0002 "antiretro_pct_analysis"
GET_TTESTS rppost rppre "improvedwater_pct__analysis"
GET_TTESTS rppost rppre "improvedsanitation_pct__analysis"
GET_TTESTS rp0015 rp9100 "undernourishment__analysis"
GET_TTESTS rppost rppre "primary_completion_85_analysis"
GET_TTESTS rppost rppre "genderratio_primary_85_analysis"
GET_TTESTS rppost rppre "inc_poverty___analysis"
GET_TTESTS rp0015 rp9000 "forest_analysis_expand"
GET_TTESTS rp0015 rp9000 "terrestrial_protected_analysis_expand"



