clear
set more off

****************************************************************************
****************************************************************************
**    NATURAL CAPITAL INDICATORS
** forest cover (% of land) * terrestrial protected area

** John W. McArthur & Krista Rasmussen
** January 2017
****************************************************************************
****************************************************************************

****************************************************************************
*** FOREST COVER * TERRESTRIAL PROTECTED AREA
* forest cover has annual data for all years (1990-2015)
* terrestrial protected area has data for only 1990, 2000, 2014
****************************************************************************
*I. Rate of progress and counterfactual calculations
	*A. Rate of progress (percentage point), pre-MDG
	*B. Rate of progress (percentage point), post-MDG
	*C. Difference in rate of progress
	*D. Extrapolate pre-MDG rate of progress to find counterfactual
*II. Country count acceleration test and lives improved
	*A. Acceleration test - country count
	*B. Forest cover increase compared to BAU trajectory
	*C. Total net loss/gain in forest cover for various categories
****************************************************************************

***************************************************
**I. RATE OF PROGRESS AND COUNTERFACTUAL CALCULATIONS
***************************************************
local lista "forest terrestrial_protected"

foreach p of local lista{
use "`p'_clean", clear

**************************************
 * A * Pre-MDG Rate of Progress: average annual percentage point change (1990-2000 and 1996-2001)
**************************************
gen rp9000 = (n2000-n1990)/10
gen rp9601 = (n2001-n1996)/5 //only possible for forest cover

**************************************
 * B * Post-MDG Rate of Progress: average annual percentage point change (2000-2015 and 2001-2015)
**************************************
gen rp0015 = (n2015-n2000)/15
 replace rp0015 = (n2014-n2000)/14 if n2015==. //forest area has data for 2015, protected land area ends at 2014
gen rp0115 = (n2015-n2001)/14 // only possible for forest cover

**********************
 * C * Calculate the difference between pre and post rates of progress
**********************
*1990-2000 v. 2000-2015 and 1996-2001 v. 2001-2015
local listb "9000 9601" //years 1990-2001  and 96-01
local listc "0015 0115" //years 2000-2015 and 01-15

foreach pre of local listb{
foreach pos of local listc{

gen difrp`pre'_`pos' = rp`pos'-rp`pre' 
label var difrp`pre'_`pos' "dif in rate of progress, (`pos')-(`pre')"

gen fulldata`pre'_`pos'=0
replace fulldata`pre'_`pos' = 1 if rp`pre'!=. & rp`pos'!=.
label var fulldata`pre'_`pos' "# countries with full data years `pre' `pos'"
}
}
drop *9601_0015 *9000_0115

**********************
 * D * Use rate of progress to generate counterfactual for 2001-2015
**********************
** at 1990-2000 and 
local listb "9000"

foreach pre of local listb{
for num 2001/2015: gen cf`pre'_X = n2000+(rp`pre'*(X - 2000)) if rp`pre'!=.
for num 2001/2015: replace cf`pre'_X = 1 if cf`pre'_X > 1 & cf`pre'_X!=. //can't have more than 100%
for num 2001/2015: label variable cf`pre'_X "`p' X extrapolation from `pre' rates"
}

** at 1996-2001 and 
local listb "9601"

foreach pre of local listb{
for num 2002/2015: gen cf`pre'_X = n2001+(rp`pre'*(X - 2001)) if rp`pre'!=.
for num 2002/2015: replace cf`pre'_X = 1 if cf`pre'_X > 1 & cf`pre'_X!=. //can't have more than 100%
for num 2002/2015: label variable cf`pre'_X "`p' X extrapolation from `pre' rates"
}

save "`p'_rpfull", replace
}


***************************************************
**II. COUNTRY COUNT ACCELERATION TEST AND FOREST COVER/LAND PROTECTED IMPROVED  
***************************************************

local lista "forest terrestrial_protected"
foreach p of local lista{
use "`p'_rpfull", clear

**************************************************************************************
 * A * Acceleration test - simple country count
**************************************************************************************

* (i) Create dummy variable for countries that had any acceleration between 1990-2000 and 2000-2015
gen difrp9000_0015_any = 0
 replace difrp9000_0015_any = 1 if difrp9000_0015>0
 replace difrp9000_0015_any = . if difrp9000_0015==.
 replace difrp9000_0015_any = 0 if rp0015<=0 & difrp9000_0015!=. //exclude countries from acceleration count that are still decreasing land cover (even if at a slower rate)

* (i) Create dummy variable for countries that had "real" acceleration between 1990-2000 and 2000-2015
 **Difference in rate is >= .33 percentage points per year
gen difrp9000_0015_1 = 0
 replace difrp9000_0015_1 = 1 if difrp9000_0015 >=.0033 
 replace difrp9000_0015_1 = . if difrp9000_0015==.
 replace difrp9000_0015_1 = 0 if rp0015<=0 & difrp9000_0015!=. //exclude countries from acceleration count that are still decreasing land cover (even if at a slower rate)
label variable difrp9000_0015_1 "rate of progress in 0015 .33 pct point greater than 9000"

save "`p'_cfmdg.dta", replace

**************************************************************************************
 * B * Use counterfactuals to determine land area affected by MDGs
**************************************************************************************

**Convert percents to total land area of forest cover
gen total_2015 = n2015 * land2015
gen total_2000 = n2000 * land2000
gen total_1990 = n1990 * land1990
gen total_2014 = n2014 * land2014 

* Counterfactual A: Land affected based on 1990-2000 rates** 
**********************
for num 2001/2015: gen xaff_cf9000_X = (nX * landX ) - (cf9000_X * landX )
for num 2001/2015: label variable xaff_cf9000_X "Counterfactual A: estimated land affected X"

 * to avoid double counting land, counterfactual totals are based on final year
gen xaff_cf9000_final  = xaff_cf9000_2015
 replace xaff_cf9000_final = xaff_cf9000_2014 if xaff_cf9000_2015==.
label variable xaff_cf9000_final "Counterfactual A: estimated land affected in final year"

 * Calculate total land affected in different groups
**All developing countries
for num 2001/2015: egen dev_cfA_land_X = sum(xaff_cf9000_X) 
for num 2001/2015: label variable dev_cfA_land_X "Counterfactual A: developing world total land affected (sq. Km) in X"

gen dev_cfA_land_final = dev_cfA_land_2015
 replace dev_cfA_land_final = dev_cfA_land_2014 if dev_cfA_land_2015==.
label variable dev_cfA_land_final "Counterfactual A: developing world total land affected (sq. Km) in final year"

**By Region
for num 2001/2015: egen region_cfA_land_X = sum(xaff_cf9000_X), by(Region)
for num 2001/2015: label variable region_cfA_land_X "Counterfactual A: by region total land affected (sq. Km) in X"

gen region_cfA_land_final = region_cfA_land_2015
 replace region_cfA_land_final = region_cfA_land_2014 if region_cfA_land_2015==.
label variable region_cfA_land_final "Counterfactual A: by region total land affected (sq. Km) in final year"

**LIC
for num 2001/2015: egen LIC_cfA_land_X = sum(xaff_cf9000_X) if IncomeGroup=="L"
for num 2001/2015: label variable LIC_cfA_land_X "Counterfactual A: LIC total land affected (sq. Km) in X"

gen LIC_cfA_land_final = LIC_cfA_land_2015
 replace LIC_cfA_land_final = LIC_cfA_land_2014 if LIC_cfA_land_2015==.
label variable LIC_cfA_land_final "Counterfactual A: LIC total land affected (sq. Km) in final year"

**LIC ex. India
for num 2001/2015: egen LICxind_cfA_land_X = sum(xaff_cf9000_X) if IncomeGroup=="L" & CountryCode!="IND"
for num 2001/2015: label variable LICxind_cfA_land_X "Counterfactual A: LIC ex-India total land affected (sq. Km) in X"

gen LICxind_cfA_land_final = LICxind_cfA_land_2015
 replace LICxind_cfA_land_final = LICxind_cfA_land_2014 if LICxind_cfA_land_2015==.
label variable LICxind_cfA_land_final "Counterfactual A: LIC total land affected (sq. Km) in final year"

**MIC
for num 2001/2015: egen MIC_cfA_land_X = sum(xaff_cf9000_X) if IncomeGroup!="L"
for num 2001/2015: label variable MIC_cfA_land_X "Counterfactual A: MIC total land affected (sq. Km) in X"

gen MIC_cfA_land_final = MIC_cfA_land_2015
 replace MIC_cfA_land_final = MIC_cfA_land_2014 if MIC_cfA_land_2015==.
label variable MIC_cfA_land_final "Counterfactual A: MIC total land affected (sq. Km) in final year"

**MIC ex. China
for num 2001/2015: egen MICxchn_cfA_land_X = sum(xaff_cf9000_X) if IncomeGroup!="L" & CountryCode!="CHN"
for num 2001/2015: label variable MICxchn_cfA_land_X "Counterfactual A: MIC total land affected (sq. Km) in X"

gen MICxchn_cfA_land_final = MICxchn_cfA_land_2015
 replace MICxchn_cfA_land_final = MICxchn_cfA_land_2015 if MICxchn_cfA_land_2015==.
label variable MICxchn_cfA_land_final "Counterfactual A: MIC ex-China total land affected (sq. Km) in final year"

**Ex. China & India
for num 2001/2015: egen xChiInd_cfA_land_X = sum(xaff_cf9000_X) if CountryCode!="CHN" & CountryCode!="IND"
for num 2001/2015: label variable xChiInd_cfA_land_X "Counterfactual A: ex-China & India total land affected (sq. Km) in X"

gen xChiInd_cfA_land_final = xChiInd_cfA_land_2015
 replace xChiInd_cfA_land_final = xChiInd_cfA_land_2014 if xChiInd_cfA_land_2015==.
label variable xChiInd_cfA_land_final "Counterfactual A: x China & India total land affected (sq. Km) in final year"


* Counterfactual B: Land area affected based on 1996-2001 rates (only for forest cover)** 
**********************
for num 2002/2015: gen xaff_cf9601_X  = (nX * landX ) - (cf9601_X * landX )
for num 2002/2015: label variable xaff_cf9000_X "Counterfactual B: estimated land affected (sq. Km) in X"

 * to avoid double counting land, counterfactual totals are based on final year
gen xaff_cf9601_final  = xaff_cf9601_2015
label variable xaff_cf9601_final "Counterfactual B: estimated land affected in final year"

 * Calculate total lives affected in different groups
**All developing countries
for num 2002/2015: egen dev_cfB_land_X = sum(xaff_cf9601_X) 
for num 2002/2015: label variable dev_cfB_land_X "Counterfactual B: developing world total land affected (sq. Km) in X"

gen dev_cfB_land_final = dev_cfB_land_2015
label variable dev_cfB_land_final "Counterfactual B: developing world total land affected (sq. Km) in final year"

**By Region
for num 2002/2015: egen region_cfB_land_X = sum(xaff_cf9601_X), by(Region)
for num 2002/2015: label variable region_cfB_land_X "Counterfactual B: by region total land affected (sq. Km) in X"

gen region_cfB_land_final = region_cfB_land_2015
label variable region_cfB_land_final "Counterfactual B: by region total land affected (sq. Km) in final year"

**LIC
for num 2002/2015: egen LIC_cfB_land_X = sum(xaff_cf9601_X) if IncomeGroup=="L"
for num 2002/2015: label variable LIC_cfB_land_X "Counterfactual B: LIC total land affected (sq. Km) in X"

gen LIC_cfB_land_final = LIC_cfB_land_2015
label variable LIC_cfB_land_final "Counterfactual B: LIC total land affected (sq. Km) in final year"

**LIC ex. India
for num 2002/2015: egen LICxind_cfB_land_X = sum(xaff_cf9601_X) if IncomeGroup=="L" & CountryCode!="IND"
for num 2002/2015: label variable LICxind_cfB_land_X "Counterfactual B: LIC ex-India total land affected (sq. Km) in X"

gen LICxind_cfB_land_final = LICxind_cfB_land_2015
label variable LICxind_cfB_land_final "Counterfactual B: LIC ex-India total land affected (sq. Km) in final year"

**MIC
for num 2002/2015: egen MIC_cfB_land_X = sum(xaff_cf9601_X) if IncomeGroup!="L"
for num 2002/2015: label variable MIC_cfB_land_X "Counterfactual B: MIC total land affected (sq. Km) in X"

gen MIC_cfB_land_final = MIC_cfB_land_2015
label variable MIC_cfB_land_final "Counterfactual B: MIC total land affected (sq. Km) in final year"

**MIC ex. China
for num 2002/2015: egen MICxchn_cfB_land_X = sum(xaff_cf9601_X) if IncomeGroup!="L" & CountryCode!="CHN"
for num 2002/2015: label variable MICxchn_cfB_land_X "Counterfactual B: MIC ex-China total land affected (sq. Km) in X"

gen MICxchn_cfB_land_final = MICxchn_cfB_land_2015
label variable MICxchn_cfB_land_final "Counterfactual B: MIC ex-China total land affected (sq. Km) in final year"

**Ex. China & India
for num 2002/2015: egen xChiInd_cfB_land_X = sum(xaff_cf9601_X) if CountryCode!="CHN" & CountryCode!="IND"
for num 2002/2015: label variable xChiInd_cfB_land_X "Counterfactual B: ex-China & India total land affected (sq. Km) in X"

gen xChiInd_cfB_land_final = xChiInd_cfB_land_2015
label variable xChiInd_cfB_land_final "Counterfactual B: ex-China & India total land affected (sq. Km) in final year"


**************************************************************************************
 * C * Generate Total net loss/gain for various categories
**************************************************************************************
**"total_year" = land area covered by forest/protected, by country

** All Developing Countries
 * total land area forested/protected
egen dev_1990 = sum(total_1990), missing 
egen dev_2000 = sum(total_2000), missing 
egen dev_2015 = sum(total_2015), missing
egen dev_2014 = sum(total_2014), missing 

** LIC ex. India
 * total land area forested/protected
egen lic_1990 = sum(total_1990) if IncomeGroup=="L" & CountryCode!="IND", missing
egen lic_2000 = sum(total_2000) if IncomeGroup=="L" & CountryCode!="IND", missing
egen lic_2015 = sum(total_2015) if IncomeGroup=="L" & CountryCode!="IND", missing
egen lic_2014 = sum(total_2014) if IncomeGroup=="L" & CountryCode!="IND", missing


** MIC ex. China
 * total land area forested/protected
egen mic_1990 = sum(total_1990) if IncomeGroup!="L" & CountryCode!="CHN", missing
egen mic_2000 = sum(total_2000) if IncomeGroup!="L" & CountryCode!="CHN", missing
egen mic_2015 = sum(total_2015) if IncomeGroup!="L" & CountryCode!="CHN", missing
egen mic_2014 = sum(total_2014) if IncomeGroup!="L" & CountryCode!="CHN", missing

** By region
 * total land area forested/protected
bysort Region: egen region_1990 = sum(total_1990), missing 
bysort Region: egen region_2000 = sum(total_2000), missing 
bysort Region: egen region_2015 = sum(total_2015), missing 
bysort Region: egen region_2014 = sum(total_2014), missing 

** Ex. China & India
 * total land area forested/protected
egen xChiInd_1990 = sum(total_1990) if CountryCode!="CHN" & CountryCode!="IND", missing 
egen xChiInd_2000 = sum(total_2000) if CountryCode!="CHN" & CountryCode!="IND", missing 
egen xChiInd_2015 = sum(total_2015) if CountryCode!="CHN" & CountryCode!="IND", missing 
egen xChiInd_2014 = sum(total_2014) if CountryCode!="CHN" & CountryCode!="IND", missing 

** Calculate net gain/loss between relevant years for each category
local listc "dev_ lic_ mic_ region_ xChiInd_" 
foreach v of local listc{
gen `v'net9000 = `v'2000 - `v'1990
label variable `v'net9000 "net gain/loss (2000-1990)"
gen `v'net0015 = `v'2015 - `v'2000
label variable `v'net0015 "net gain/loss (2015-2000)"
gen `v'net0014 = `v'2014 - `v'2000
label variable `v'net0014 "net gain/loss (2014-2000)"
gen `v'net9015 = `v'2015 - `v'1990
label variable `v'net9015 "net gain/loss (2015-1990)"
gen `v'net9014 = `v'2014 - `v'1990
label variable `v'net9014 "net gain/loss (2014-1990)"
}

** Only India
gen india_net9000 = (n2000*land2000)-(n1990*land1990) if CountryCode=="IND"
gen india_net0015 = (n2015*land2015)-(n2000*land2000) if CountryCode=="IND"
gen india_net9015 = (n2015*land2015)-(n1990*land1990) if CountryCode=="IND"
gen india_net9014 = (n2014*land2014)-(n1990*land1990) if CountryCode=="IND"
gen india_net0014 = (n2014*land2014)-(n2000*land2000) if CountryCode=="IND"

** Only China
gen china_net9000 = (n2000*land2000)-(n1990*land1990) if CountryCode=="CHN"
gen china_net0015 = (n2015*land2015)-(n2000*land2000) if CountryCode=="CHN"
gen china_net9015 = (n2015*land2015)-(n1990*land1990) if CountryCode=="CHN"
gen china_net9014 = (n2014*land2014)-(n1990*land1990) if CountryCode=="CHN"
gen china_net0014 = (n2014*land2014)-(n2000*land2000) if CountryCode=="CHN"

save "`p'_analysis_expand", replace
}

