clear
set more off

****************************************************************************
****************************************************************************
**    MORTALITY INDICATORS
** maternal mortality ratio * under-5 mortality rate 

** John W. McArthur & Krista Rasmussen
** January 2017
****************************************************************************
****************************************************************************

****************************************************************************
***MATERNAL MORTALITY RATIO and UNDER-5 MORTALITY RATE
****************************************************************************
*I. Rate of progress and counterfactual calculations
	*A. Pre-MDG average annual proportional rate of progress 
	*B. Post-MDG average annual proportional rate of progress
	*C. Difference in rate of progress
	*D. Extrapolate pre-MDG rate of progress to find counterfactual
*IIA. Country count acceleration test and incremental lives saved - MMR
	*A. Acceleration test - country count MMR
	*B. Lives saved compared to BAU trajectory MMR
*IIB. Country count acceleration test and incremental lives saved - U5MR
	*A. Acceleration test - country count U5MR
	*B. Lives saved compared to BAU trajectory U5MR	
****************************************************************************

***************************************************
**I. RATE OF PROGRESS AND COUNTERFACTUAL CALCULATIONS
***************************************************
local lista "maternal_mort_modeled u5mr"
foreach p of local lista {
use "`p'_clean"

*********************************
 * A. * Pre MDG Average Annual Rate of Change
*********************************
	*9000 is defined as 1990-2000
	*9601 is defined as 1996-2001

   *flipping direction of slope so higher rate of change = improvement
gen rp9000 = 1- (n2000/n1990)^(1/10) 
gen rp9601 = 1- (n2001/n1996)^(1/5)

*********************************
* B. * Post MDG Average Annual Rate of Change
*********************************
	*0015 is defined as 2000-2015
	*0115 is defined as 2001-2015

  *flipping direction of slope so higher rate of change = improvement
gen rp0015 = 1- (n2015/n2000)^(1/15)
gen rp0115 = 1- (n2015/n2001)^(1/14) 

*********************************
 * C * Calculate the absolute difference between pre and post rates of progress
*********************************
 *1990-2000 v. 2000-2015 and 1996-2001 v. 2001-2015
local listb "9000 9601" //years 1990-2000 and 96-01
local listc "0015 0115" //years 2000-2015 and 01-15

foreach pre of local listb{
foreach pos of local listc{

gen difrp`pre'_`pos' = rp`pos'-rp`pre' 
label var difrp`pre'_`pos' "dif in rate of progress, (`pos')-(`pre')"

gen fulldata`pre'_`pos'=0
replace fulldata`pre'_`pos' = 1 if rp`pre'!=. & rp`pos'!=.
label var fulldata`pre'_`pos' "# countries with full data for `pre' `pos' "
}
}
 * drop data we are uninterested in 
drop *9000_0115 *9601_0015

*********************************
* D. * Use rate of progress to generate counterfactual for 2000-2015
*********************************
** Counterfactual A: 1990-2000 rates
local listb "9000"

foreach pre of local listb{
for num 2001/2015: gen cf`pre'_X = n2000*((1-rp`pre')^(X-2000))
for num 2001/2015: label variable cf`pre'_X "`p' X extrapolation from `pre' rates"
}

 ** Counterfactual B: 1996-2001 rates
local listb "9601"

foreach pre of local listb{
for num 2002/2015: gen cf`pre'_X = n2001*((1-rp`pre')^(X-2001))
for num 2002/2015: label variable cf`pre'_X "`p' X extrapolation from `pre' rates"
}
save "`p'_rpfull.dta", replace
}


***************************************************
**IIA. MATERNAL MORTALITY COUNTRY COUNT ACCELERATION TEST AND LIVES IMPROVED 
***************************************************

use "maternal_mort_modeled_rpfull.dta", clear

**************************************************************************************
 * A * Acceleration test - simple country count
**************************************************************************************
* (i) Create dummy variable for countries that had any acceleration between 1990-2000 and 2000-2015
gen difrp9000_0015_any = 0
 replace difrp9000_0015_any = 1 if difrp9000_0015>0
 replace difrp9000_0015_any = . if difrp9000_0015==.
 replace difrp9000_0015_any = 0 if rp0015<=0 & difrp9000_0015!=. //exclude countries from acceleration count that are still increasing MMR (even if at a slower rate)

* (ii) Create dummy variable for countries that had "real" acceleration between 1990-2000 and 2000-2015
* Real = 1 percentage point difference between pre and post rates of progress
gen difrp9000_0015_1 = 0
 replace difrp9000_0015_1 = 1 if difrp9000_0015>=.01
 replace difrp9000_0015_1 = . if difrp9000_0015==.
 replace difrp9000_0015_1 = 0 if rp0015<=0 & difrp9000_0015!=. //exclude countries from acceleration count that are still increasing MMR (even if at a slower rate)

save "maternal_mort_modeled_cfmdg.dta", replace

**************************************************************************************
 * B * Use counterfactuals to determine number of lives saved above BAU trajectory
**************************************************************************************

**Convert ratios to absolute numbers - MMR is deaths per 100,000 live births
for num 1990/2015: gen total_X = nX * (birthX / 100000)
for num 1990/2015: label variable total_X "total maternal deaths in country in X"

** COUNTERFACTUAL A *
********************
* Counterfactual A: maternal deaths based on 1990-2000 rates** 
for num 2001/2015: gen xmmdeaths_cf9000_X  = (cf9000_X / nX) * total_X
for num 2001/2015: label variable xmmdeaths_cf9000_X "estimated X deaths if scaled by (cf9000_X/MMR in X)"

* Counterfactual A: rough estimate of lives saved in 2001-2015 *
for num 2001/2015: gen dif_mdg_cfA_X = xmmdeaths_cf9000_X - total_X
for num 2001/2015: label variable dif_mdg_cfA_X "Counterfactual A: est. lives saved in X, extrap 1990-2000"

 * Calculate total incremental lives saved in different groups
**All developing countries
for num 2001/2015: egen dev_cfA_lives_X = sum(dif_mdg_cfA_X) 
for num 2001/2015: label variable dev_cfA_lives_X "Counterfactual A: developing world total lives affected in X"
egen dev_cfA_lives_total = rowtotal(dev_cfA_lives_2001-dev_cfA_lives_2015), missing
label variable dev_cfA_lives_total "Counterfactual A: developing world total lives saved 2001-2015"
 * count number of countries within developing country sample (those with data)
gen count = 1
egen dev_cfA_count_2015 = sum(count) if dif_mdg_cfA_2015!=.

**By Region
for num 2001/2015: egen region_cfA_lives_X = sum(dif_mdg_cfA_X), by(Region)
for num 2001/2015: label variable region_cfA_lives_X "Counterfactual A: by region total lives affected in X"
egen region_cfA_lives_total = rowtotal(region_cfA_lives_2001-region_cfA_lives_2015), missing
label variable region_cfA_lives_total "Counterfactual A: by region, total lives saved 2001-2015"

**LIC
for num 2001/2015: egen LIC_cfA_lives_X = sum(dif_mdg_cfA_X) if IncomeGroup=="L"
for num 2001/2015: label variable LIC_cfA_lives_X "Counterfactual A: LIC total lives affected in X"
egen LIC_cfA_lives_total = rowtotal(LIC_cfA_lives_2001-LIC_cfA_lives_2015), missing
label variable LIC_cfA_lives_total "Counterfactual A: LIC total lives saved 2001-2015"

**LIC ex. India
for num 2001/2015: egen LICxind_cfA_lives_X = sum(dif_mdg_cfA_X) if IncomeGroup=="L" & CountryCode!="IND"
for num 2001/2015: label variable LICxind_cfA_lives_X "Counterfactual A: LIC ex-India total lives affected in X"
egen LICxind_cfA_lives_total = rowtotal(LICxind_cfA_lives_2001-LICxind_cfA_lives_2015), missing
label variable LICxind_cfA_lives_total "Counterfactual A: LIC ex-India total lives saved 2001-2015"

**MIC
for num 2001/2015: egen MIC_cfA_lives_X = sum(dif_mdg_cfA_X) if IncomeGroup!="L"
for num 2001/2015: label variable MIC_cfA_lives_X "Counterfactual A: MIC total lives affected in X"
egen MIC_cfA_lives_total = rowtotal (MIC_cfA_lives_2001-MIC_cfA_lives_2015), missing
label variable MIC_cfA_lives_total "Counterfactual A: MIC total lives saved 2001-2015"

**MIC ex. China
for num 2001/2015: egen MICxchn_cfA_lives_X = sum(dif_mdg_cfA_X) if IncomeGroup!="L" & CountryCode!="CHN"
for num 2001/2015: label variable MICxchn_cfA_lives_X "Counterfactual A: MIC ex-China total lives affected in X"
egen MICxchn_cfA_lives_total = rowtotal (MICxchn_cfA_lives_2001-MICxchn_cfA_lives_2015), missing
label variable MICxchn_cfA_lives_total "Counterfactual A: MIC ex-China total lives saved 2001-2015"

**Ex. China & India
for num 2001/2015: egen xChiInd_cfA_lives_X = sum(dif_mdg_cfA_X) if CountryCode!="CHN" & CountryCode!="IND"
for num 2001/2015: label variable xChiInd_cfA_lives_X "Counterfactual A: ex-China & India total lives affected in X"
egen xChiInd_cfA_lives_total = rowtotal(xChiInd_cfA_lives_2001-xChiInd_cfA_lives_2015), missing
label variable xChiInd_cfA_lives_total "Counterfactual A: developing world ex-China & India total lives saved 2001-2015"

** China only
for num 2001/2015: egen China_cfA_lives_X = sum(dif_mdg_cfA_X) if CountryCode=="CHN"
for num 2001/2015: label variable China_cfA_lives_X "Counterfactual A: China total lives affected in X"
egen China_cfA_lives_total = rowtotal(China_cfA_lives_2001-China_cfA_lives_2015), missing
label variable China_cfA_lives_total "Counterfactual A: developing world China total lives saved 2001-2015"

** India only
for num 2001/2015: egen India_cfA_lives_X = sum(dif_mdg_cfA_X) if CountryCode=="IND"
for num 2001/2015: label variable India_cfA_lives_X "Counterfactual A: India total lives affected in X"
egen India_cfA_lives_total = rowtotal(India_cfA_lives_2001-India_cfA_lives_2015), missing
label variable India_cfA_lives_total "Counterfactual A: developing world India total lives saved 2001-2015"

** Rest of World (ex. SSA, China, & India)
for num 2001/2015: egen ROW_cfA_lives_X = sum(dif_mdg_cfA_X) if CountryCode!="IND" & CountryCode!="CHN" & Region!="SSA"
for num 2001/2015: label variable ROW_cfA_lives_X "Counterfactual A: Rest of World total lives affected in X"
egen ROW_cfA_lives_total = rowtotal(ROW_cfA_lives_2001-ROW_cfA_lives_2015), missing
label variable ROW_cfA_lives_total "Counterfactual A: Rest of world total lives saved 2001-2015"


** COUNTERFACTUAL B *
********************
* Counterfactual B: MMR based on 1996-2001 rates** 
for num 2002/2015: gen xmmdeaths_cf9601_X  = (cf9601_X / nX) * total_X
for num 2002/2015: label variable xmmdeaths_cf9601_X "estimated X deaths if scaled by (cf9601_X/MMR in X)"

* Counterfactual B: rough estimate of lives saved in 2002-2015 *
for num 2002/2015: gen dif_mdg_cfB_X = xmmdeaths_cf9601_X - total_X
for num 2002/2015: label variable dif_mdg_cfB_X "Counterfactual B: est. lives saved in X, extrap 1996-2001"

 * Calculate total lives affected in different groups
**All developing countries
for num 2002/2015: egen dev_cfB_lives_X = sum(dif_mdg_cfB_X) 
for num 2002/2015: label variable dev_cfB_lives_X "Counterfactual B: developing world total lives affected in X"
egen dev_cfB_lives_total = rowtotal(dev_cfB_lives_2002-dev_cfB_lives_2015), missing
label variable dev_cfB_lives_total "Counterfactual B: developing world total lives saved 2002-2015"
 * count number of countries within developing country sample (those with data)
egen dev_cfB_count_2015 = sum(count) if dif_mdg_cfB_2015!=.

**By Region
for num 2002/2015: egen region_cfB_lives_X = sum(dif_mdg_cfB_X), by(Region)
for num 2002/2015: label variable region_cfB_lives_X "Counterfactual B: by region total lives affected in X"
egen region_cfB_lives_total = rowtotal(region_cfB_lives_2002-region_cfB_lives_2015), missing
label variable region_cfB_lives_total "Counterfactual B: by region, total lives saved 2002-2015"

**LIC
for num 2002/2015: egen LIC_cfB_lives_X = sum(dif_mdg_cfB_X) if IncomeGroup=="L"
for num 2002/2015: label variable LIC_cfB_lives_X "Counterfactual B: LIC total lives affected in X"
egen LIC_cfB_lives_total = rowtotal(LIC_cfB_lives_2002-LIC_cfB_lives_2015), missing
label variable LIC_cfB_lives_total "Counterfactual B: LIC total lives saved 2002-2015"

**LIC ex. India
for num 2002/2015: egen LICxind_cfB_lives_X = sum(dif_mdg_cfB_X) if IncomeGroup=="L" & CountryCode!="IND"
for num 2002/2015: label variable LICxind_cfB_lives_X "Counterfactual B: LIC ex-India total lives affected in X"
egen LICxind_cfB_lives_total = rowtotal(LICxind_cfB_lives_2002-LICxind_cfB_lives_2015), missing
label variable LICxind_cfB_lives_total "Counterfactual B: LIC ex-India total lives saved 2002-2015"

**MIC
for num 2002/2015: egen MIC_cfB_lives_X = sum(dif_mdg_cfB_X) if IncomeGroup!="L"
for num 2002/2015: label variable MIC_cfB_lives_X "Counterfactual B: MIC total lives affected in X"
egen MIC_cfB_lives_total = rowtotal(MIC_cfB_lives_2002-MIC_cfB_lives_2015), missing
label variable MIC_cfB_lives_total "Counterfactual B: MIC total lives saved 2002-2015"

**MIC ex. China
for num 2002/2015: egen MICxchn_cfB_lives_X = sum(dif_mdg_cfB_X) if IncomeGroup!="L" & CountryCode!="CHN"
for num 2002/2015: label variable MICxchn_cfB_lives_X "Counterfactual B: MIC ex-China total lives affected in X"
egen MICxchn_cfB_lives_total = rowtotal (MICxchn_cfB_lives_2002-MICxchn_cfB_lives_2015), missing
label variable MICxchn_cfB_lives_total "Counterfactual B: MIC ex-China total lives saved 2001-2015"

**Ex. China & India
for num 2002/2015: egen xChiInd_cfB_lives_X = sum(dif_mdg_cfB_X) if CountryCode!="CHN" & CountryCode!="IND"
for num 2002/2015: label variable xChiInd_cfB_lives_X "Counterfactual B: ex-China & India total lives affected in X"
egen xChiInd_cfB_lives_total = rowtotal(xChiInd_cfB_lives_2002-xChiInd_cfB_lives_2015), missing
label variable xChiInd_cfB_lives_total "Counterfactual B: developing world ex-China & India total lives saved 2002-2015"

** China only
for num 2002/2015: egen China_cfB_lives_X = sum(dif_mdg_cfB_X) if CountryCode=="CHN"
for num 2002/2015: label variable China_cfB_lives_X "Counterfactual B: China total lives affected in X"
egen China_cfB_lives_total = rowtotal(China_cfB_lives_2002-China_cfB_lives_2015), missing
label variable China_cfB_lives_total "Counterfactual B: developing world China total lives saved 2002-2015"

** India only
for num 2002/2015: egen India_cfB_lives_X = sum(dif_mdg_cfB_X) if CountryCode=="IND"
for num 2002/2015: label variable India_cfB_lives_X "Counterfactual B: India total lives affected in X"
egen India_cfB_lives_total = rowtotal(India_cfB_lives_2002-India_cfB_lives_2015), missing
label variable India_cfB_lives_total "Counterfactual B: developing world India total lives saved 2002-2015"

** Rest of world (ex. India, China, SSA)
for num 2002/2015: egen ROW_cfB_lives_X = sum(dif_mdg_cfB_X) if CountryCode!="IND" & CountryCode!="CHN" & Region!="SSA"
for num 2002/2015: label variable ROW_cfB_lives_X "Counterfactual B: Rest of world total lives affected in X"
egen ROW_cfB_lives_total = rowtotal(ROW_cfB_lives_2002-ROW_cfB_lives_2015), missing
label variable ROW_cfB_lives_total "Counterfactual B: Rest of world total lives saved 2002-2015"

save "maternal_mort_modeled_analysis.dta", replace



***************************************************
**IIB. UNDER 5 MORTALITY RATE COUNTRY COUNT ACCELERATION TEST AND LIVES IMPROVED 
***************************************************
use "u5mr_rpfull.dta", clear

**************************************************************************************
 * A * Acceleration test - simple country count
**************************************************************************************

* (i) Create dummy variable for countries that had any acceleration between 1990-2000 and 2000-2015
gen difrp9000_0015_any = 0
 replace difrp9000_0015_any = 1 if difrp9000_0015>0
 replace difrp9000_0015_any = . if difrp9000_0015==.
 replace difrp9000_0015_any = 0 if rp0015<=0 & difrp9000_0015!=. //exclude countries from acceleration count that are still increasing U5MR (even if at a slower rate)

* (ii) Create dummy variable for countries that had "real" acceleration between 1990-2000 and 2000-2015
* Real = 1 percentage point difference between pre and post rates of progress
gen difrp9000_0015_1 = 0
 replace difrp9000_0015_1 = 1 if difrp9000_0015>=.01
 replace difrp9000_0015_1 = . if difrp9000_0015==.
 replace difrp9000_0015_1 = 0 if rp0015<=0 & difrp9000_0015!=. //exclude countries from acceleration count that are still increasing U5MR (even if at a slower rate)

**Drop HIC
save "u5mr_cfmdg.dta", replace
replace IndicatorName = "u5mr"

**************************************************************************************
 * B * Use counterfactuals to determine number of lives saved above BAU trajectory
**************************************************************************************

** COUNTERFACTUAL A *
**********************
* Counterfactual A: U5 deaths based on 1990-2000 rates** 
for num 2001/2015: gen xcmdeaths_cf9000_X  = (cf9000_X / nX) * cdX
for num 2001/2015: label variable xcmdeaths_cf9000_X "estimated X deaths if scaled by (cf9000_X/CMR in X)"

* Counterfactual A: rough estimate of lives saved in 2001-2015 *
for num 2001/2015: gen dif_mdg_cfA_X = xcmdeaths_cf9000_X - cdX
for num 2001/2015: label variable dif_mdg_cfA_X "Counterfactual A: est. lives saved in X, extrap 1990-2000"

 * Calculate total lives affected in different groups
**All developing countries
for num 2001/2015: egen dev_cfA_lives_X = sum(dif_mdg_cfA_X) 
for num 2001/2015: label variable dev_cfA_lives_X "Counterfactual A: developing world total lives affected in X"
egen dev_cfA_lives_total = rowtotal(dev_cfA_lives_2001-dev_cfA_lives_2015), missing
label variable dev_cfA_lives_total "Counterfactual A: developing world total lives saved 2001-2015"
 * calculate number of countries within developing country sample (those with data)
gen count = 1
egen dev_cfA_count_2015 = sum(count) if dif_mdg_cfA_2015!=.

**By Region
for num 2001/2015: egen region_cfA_lives_X = sum(dif_mdg_cfA_X), by(Region)
for num 2001/2015: label variable region_cfA_lives_X "Counterfactual A: by region, total lives affected in X"
egen region_cfA_lives_total = rowtotal(region_cfA_lives_2001-region_cfA_lives_2015), missing
label variable region_cfA_lives_total "Counterfactual A: by region, total lives saved 2001-2015"

**LIC
for num 2001/2015: egen LIC_cfA_lives_X = sum(dif_mdg_cfA_X) if IncomeGroup=="L"
for num 2001/2015: label variable LIC_cfA_lives_X "Counterfactual A: LIC total lives affected in X"
egen LIC_cfA_lives_total = rowtotal(LIC_cfA_lives_2001-LIC_cfA_lives_2015), missing
label variable LIC_cfA_lives_total "Counterfactual A: LIC total lives saved 2001-2015"

**LIC ex. India
for num 2001/2015: egen LICxind_cfA_lives_X = sum(dif_mdg_cfA_X) if IncomeGroup=="L" & CountryCode!="IND"
for num 2001/2015: label variable LICxind_cfA_lives_X "Counterfactual A: LIC ex-India total lives affected in X"
egen LICxind_cfA_lives_total = rowtotal(LICxind_cfA_lives_2001-LICxind_cfA_lives_2015), missing
label variable LICxind_cfA_lives_total "Counterfactual A: LIC ex-India total lives saved 2001-2015"

**MIC
for num 2001/2015: egen MIC_cfA_lives_X = sum(dif_mdg_cfA_X) if IncomeGroup!="L"
for num 2001/2015: label variable MIC_cfA_lives_X "Counterfactual A: MIC total lives affected in X"
egen MIC_cfA_lives_total = rowtotal (MIC_cfA_lives_2001-MIC_cfA_lives_2015), missing
label variable MIC_cfA_lives_total "Counterfactual A: MIC total lives saved 2001-2015"

**MIC ex. China
for num 2001/2015: egen MICxchn_cfA_lives_X = sum(dif_mdg_cfA_X) if IncomeGroup!="L" & CountryCode!="CHN"
for num 2001/2015: label variable MICxchn_cfA_lives_X "Counterfactual A: MIC ex-China total lives affected in X"
egen MICxchn_cfA_lives_total = rowtotal (MICxchn_cfA_lives_2001-MICxchn_cfA_lives_2015), missing
label variable MICxchn_cfA_lives_total "Counterfactual A: MIC ex-China total lives saved 2001-2015"

**Ex. China & India
for num 2001/2015: egen xChiInd_cfA_lives_X = sum(dif_mdg_cfA_X) if CountryCode!="CHN" & CountryCode!="IND"
for num 2001/2015: label variable xChiInd_cfA_lives_X "Counterfactual A: ex-China & India total lives affected in X"
egen xChiInd_cfA_lives_total = rowtotal(xChiInd_cfA_lives_2001-xChiInd_cfA_lives_2015), missing
label variable xChiInd_cfA_lives_total "Counterfactual A: developing world ex-China & India total lives saved 2001-2015"

** China only
for num 2001/2015: egen China_cfA_lives_X = sum(dif_mdg_cfA_X) if CountryCode=="CHN"
for num 2001/2015: label variable China_cfA_lives_X "Counterfactual A: China total lives affected in X"
egen China_cfA_lives_total = rowtotal(China_cfA_lives_2001-China_cfA_lives_2015), missing
label variable China_cfA_lives_total "Counterfactual A: developing world China total lives saved 2001-2015"

** India only
for num 2001/2015: egen India_cfA_lives_X = sum(dif_mdg_cfA_X) if CountryCode=="IND"
for num 2001/2015: label variable India_cfA_lives_X "Counterfactual A: India total lives affected in X"
egen India_cfA_lives_total = rowtotal(India_cfA_lives_2001-India_cfA_lives_2015), missing
label variable India_cfA_lives_total "Counterfactual A: developing world India total lives saved 2001-2015"

** Rest of World (ex. China, India, SSA)
for num 2001/2015: egen ROW_cfA_lives_X = sum(dif_mdg_cfA_X) if CountryCode!="IND" & CountryCode!="CHN" & Region!="SSA"
for num 2001/2015: label variable ROW_cfA_lives_X "Counterfactual A: Rest of world total lives affected in X"
egen ROW_cfA_lives_total = rowtotal(ROW_cfA_lives_2001-ROW_cfA_lives_2015), missing
label variable ROW_cfA_lives_total "Counterfactual A: Rest of world total lives saved 2001-2015"



** COUNTERFACTUAL B *
**********************
* Counterfactual B: U5 deaths based on 1996-2001 rates** 
for num 2002/2015: gen xcmdeaths_cf9601_X  = (cf9601_X / nX) * cdX
for num 2002/2015: label variable xcmdeaths_cf9601_X "estimated X deaths if scaled by (cf9601_X/MMR in X)"

* Counterfactual B: rough estimate of lives saved in 2002-2015 *
for num 2002/2015: gen dif_mdg_cfB_X = xcmdeaths_cf9601_X - cdX
for num 2002/2015: label variable dif_mdg_cfB_X "Counterfactual B: est. lives saved in X, extrap 1996-2001"

 * Calculate total lives affected in different groups
**All developing countries
for num 2002/2015: egen dev_cfB_lives_X = sum(dif_mdg_cfB_X) 
for num 2002/2015: label variable dev_cfB_lives_X "Counterfactual B: developing world total lives affected in X"
egen dev_cfB_lives_total = rowtotal(dev_cfB_lives_2002-dev_cfB_lives_2015), missing
label variable dev_cfB_lives_total "Counterfactual B: developing world total lives saved 2002-2015"
 * calculate number of countries within developing country sample (those with data)
egen dev_cfB_count_2015 = sum(count) if dif_mdg_cfB_2015!=.

**By Region
for num 2002/2015: egen region_cfB_lives_X = sum(dif_mdg_cfB_X), by(Region)
for num 2002/2015: label variable region_cfB_lives_X "Counterfactual B: by region, total lives affected in X"
egen region_cfB_lives_total = rowtotal(region_cfB_lives_2002-region_cfB_lives_2015), missing
label variable region_cfB_lives_total "Counterfactual B: by region, total lives saved 2002-2015"

**LIC
for num 2002/2015: egen LIC_cfB_lives_X = sum(dif_mdg_cfB_X) if IncomeGroup=="L"
for num 2002/2015: label variable LIC_cfB_lives_X "Counterfactual B: LIC total lives affected in X"
egen LIC_cfB_lives_total = rowtotal(LIC_cfB_lives_2002-LIC_cfB_lives_2015), missing
label variable LIC_cfB_lives_total "Counterfactual B: LIC total lives saved 2002-2015"

**LIC ex. India
for num 2002/2015: egen LICxind_cfB_lives_X = sum(dif_mdg_cfB_X) if IncomeGroup=="L" & CountryCode!="IND"
for num 2002/2015: label variable LICxind_cfB_lives_X "Counterfactual B: LIC ex-India total lives affected in X"
egen LICxind_cfB_lives_total = rowtotal(LICxind_cfB_lives_2002-LICxind_cfB_lives_2015), missing
label variable LICxind_cfB_lives_total "Counterfactual B: LIC ex-India total lives saved 2002-2015"

**MIC
for num 2002/2015: egen MIC_cfB_lives_X = sum(dif_mdg_cfB_X) if IncomeGroup!="L"
for num 2002/2015: label variable MIC_cfB_lives_X "Counterfactual B: MIC total lives affected in X"
egen MIC_cfB_lives_total = rowtotal(MIC_cfB_lives_2002-MIC_cfB_lives_2015), missing
label variable MIC_cfB_lives_total "Counterfactual B: MIC total lives saved 2002-2015"

**MIC ex. China
for num 2002/2015: egen MICxchn_cfB_lives_X = sum(dif_mdg_cfB_X) if IncomeGroup!="L" & CountryCode!="CHN"
for num 2002/2015: label variable MICxchn_cfB_lives_X "Counterfactual B: MIC ex-China total lives affected in X"
egen MICxchn_cfB_lives_total = rowtotal (MICxchn_cfB_lives_2002-MICxchn_cfB_lives_2015), missing
label variable MICxchn_cfB_lives_total "Counterfactual B: MIC ex-China total lives saved 2002-2015"

**Ex. China & India
for num 2002/2015: egen xChiInd_cfB_lives_X = sum(dif_mdg_cfB_X) if CountryCode!="CHN" & CountryCode!="IND"
for num 2002/2015: label variable xChiInd_cfB_lives_X "Counterfactual B: ex-China & India total lives affected in X"
egen xChiInd_cfB_lives_total = rowtotal(xChiInd_cfB_lives_2002-xChiInd_cfB_lives_2015), missing
label variable xChiInd_cfB_lives_total "Counterfactual B: developing world ex-China & India total lives saved 2002-2015"

** China only
for num 2002/2015: egen China_cfB_lives_X = sum(dif_mdg_cfB_X) if CountryCode=="CHN"
for num 2002/2015: label variable China_cfB_lives_X "Counterfactual B: China total lives affected in X"
egen China_cfB_lives_total = rowtotal(China_cfB_lives_2002-China_cfB_lives_2015), missing
label variable China_cfB_lives_total "Counterfactual B: developing world China total lives saved 2002-2015"

** India only
for num 2002/2015: egen India_cfB_lives_X = sum(dif_mdg_cfB_X) if CountryCode=="IND"
for num 2002/2015: label variable India_cfB_lives_X "Counterfactual B: India total lives affected in X"
egen India_cfB_lives_total = rowtotal(India_cfB_lives_2002-India_cfB_lives_2015), missing
label variable India_cfB_lives_total "Counterfactual B: developing world India total lives saved 2002-2015"

** Rest of World (ex. China, India, SSA)
for num 2002/2015: egen ROW_cfB_lives_X = sum(dif_mdg_cfB_X) if CountryCode!="IND" & CountryCode!="CHN" & Region!="SSA"
for num 2002/2015: label variable ROW_cfB_lives_X "Counterfactual B: Rest of world total lives affected in X"
egen ROW_cfB_lives_total = rowtotal(ROW_cfB_lives_2002-ROW_cfB_lives_2015), missing
label variable ROW_cfB_lives_total "Counterfactual B: Rest of world total lives saved 2002-2015"

save "u5mr_analysis.dta", replace



