clear
set more off

****************************************
****************************************
**		GUIDE TO STATA FILES FOR
**    		Change Of Pace: 
** 		Accelerations and advances 
** during the Millennium Development Goal era

** John W. McArthur & Krista Rasmussen
** January 2017
****************************************
****************************************

* Data files include 154 UN member states, as classified by the World Bank 
* as low or middle income in calendar year 2000. 

** Population data comes from World Bank, WDI open data (2016) 
** Primary school-aged population comes from U.N.-DESA
** Total child deaths from U.N.-IGME (2015)
** Births from World Bank, WDI open data (2016)
** Total land area from World Bank, WDI open data (2016)	

****************************************
****************************************
* Analysis do-files by indicator category
****************************************
****************************************

****************************************
*1. Mortality indicators
* Under-5 child mortality rate "u5mr_clean.dta"
* Maternal mortality rate "maternal_mort_modeled_clean.dta"
****************************************
do "2_mortality.do"

****************************************
*2. Infectious disease indicators
* Tuberculosis deaths "TB_deaths.dta"
* Malaria deaths "malaria_deaths_WHO.dta"
* HIV/AIDS deaths "HIV_deaths_unaids2015.dta" + "HIV_deaths_WHO.dta"
* Antiretroviral therapy coverage "antiretro_pct_clean"
****************************************
do "2_infectious.do"

****************************************
*3. Indicators with 50 percent targets
* Access to water "improvedwater_pct_clean.dta"
* Access to sanitation "improvedsanitation_pct_clean.dta"
* Undernourishment (country level and aggregate) "undernourishment_clean.dta" + "undernourishment_AG_clean.dta"
* Income poverty (country level) - use for country-level tests "inc_poverty_clean.dta"
****************************************
do "2_50pct.do"

****************************************
*4. Indicators with 100 percent targets
* Primary school completion rate (country level and aggregate) "primary_completion_85_clean.dta" + "primary_completion_ag_clean.dta"
* Gender parity index in primary, secondary, tertiary "genderratio_primary_85_clean.dta" + "genderratio_secondary_85_clean.dta" + "genderratio_tertiary_85_clean.dta"
****************************************
do "2_100pct.do"

****************************************
*5. Extreme income poverty
* Income poverty (aggregate) - use for summing lives improved across countries "poverty_HCT.dta" + "chinainda_individual_HCT_long.dta" + "chinainda_individual_HCT.dta"
****************************************
do "2_povertyAg.do"

****************************************
*6. Natural capital 
* forest cover "forest_clean.dta"
* terretrial protected area "terrestrial_protected_clean.dta"
****************************************
do "2_natural.do"

****************************************
*7. Tests/graphs
* t-test
* Synthesis graphs
****************************************

**T-test comparing difference in mean rates of progress pre- and post-MDGs
do "ttest_summary.do"

**Synthesis graphs(Figure 5.1-5.4): acceleration ratio vs. share of problem eliminated
do "F5.1-5.4 synthesis scatters.do"


