clear
set more off

use "fulldataset_SDG.dta", clear

**********************************
* For currently off-track countries 
 ** calculate current unweighted average rate of progress and average rate increase required
**********************************

* For Table 3: average speed needed for off-track countries to meet target by 2030
**1. Mean of current rate of progress
**2. Mean of needed rate of progress to reach target, exclude countries that meet target as of 2015 but are on (negative) trajectory to miss target by 2030
local lista "u5mr_ mmr_ nmr_"
foreach a of local lista{

*1. Mean of current rate
egen `a'mean_rp0515 = mean(`a'rp0515) if `a'sdgyes2030_0515==0
sort `a'mean_rp0515
carryforward `a'mean_rp0515, replace

*2. Mean of needed rate
egen `a'mean_rpNEED = mean(`a'rpSDGneed) if `a'sdgyes2030_0515==0 & `a'rpSDGneed>0 & `a'rpSDGneed!=.
sort `a'mean_rpNEED
carryforward `a'mean_rpNEED, replace
}

local listb "water_ sanitation_"
foreach b of local listb{
*1. Mean of current rate
egen `b'mean_rp0515 = mean(`b'rp) if `b'sdgyes2030==0
sort `b'mean_rp0515
carryforward `b'mean_rp0515, replace

*2. Mean of needed rate
egen `b'mean_rpNEED = mean(`b'rpSDGneed) if `b'sdgyes2030==0 
sort `b'mean_rpNEED
carryforward `b'mean_rpNEED, replace
}

keep *mean_rp0515 *mean_rpNEED 
collapse (first) *mean_rp0515 *mean_rpNEED

save "SDG_incgroup_mean.dta", replace

***********************************
* Calculate number of countries under each grouping of rate increase required
***********************************
use "fulldataset_SDG.dta", clear

local lista "u5mr mmr nmr water sanitation"
foreach p of local lista{

gen `p'_0_1 = 1 if `p'_pctpSDGneed>0 & `p'_pctpSDGneed<.01 & `p'_pctpSDGneed!=.
 label variable `p'_0_1 "pct. point increase >0 but <1 to reach SDG"
gen `p'_1_2 = 1 if `p'_pctpSDGneed>=.01 & `p'_pctpSDGneed<.02 & `p'_pctpSDGneed!=.
 label variable `p'_1_2 "pct. point increase >=1 but <2 to reach SDG"
gen `p'_2_3 = 1 if `p'_pctpSDGneed>=.02 & `p'_pctpSDGneed<.03 & `p'_pctpSDGneed!=.
 label variable `p'_2_3 "pct. point increase >=2 but <3 to reach SDG"
gen `p'_3_4 = 1 if `p'_pctpSDGneed>=.03 & `p'_pctpSDGneed<.04 & `p'_pctpSDGneed!=.
 label variable `p'_3_4 "pct. point increase >=3 but <4 to reach SDG"
gen `p'_4plus = 1 if `p'_pctpSDGneed>=.04 & `p'_pctpSDGneed!=.
 label variable `p'_1_2 "pct. point increase >=4 to reach SDG"
  
local listb "_0_1 _1_2 _2_3 _3_4 _4plus"
foreach b of local listb{
egen `p'alltol`b' = sum(`p'`b')
 label variable `p'alltol`b' "count of all countries requiring `b' pct. point increase"
egen `p'reg`b' = sum(`p'`b'), by(Region)
 label variable `p'reg`b' "By region count of countries requiring `b' pct. point increase"
egen `p'inc`b' = sum(`p'`b'), by(IncomeGroup)
 label variable `p'inc`b' "By IncomeGroup count of countries requiring `b' pct. point increase"
}
} 
 
save "rpSDGneed_counts.dta", replace 

