clear;
clc;
close all;
y = xlsread('bls.xls','nsa','EZ3:EZ126');
y = y';
addpath(fullfile(cd, '/ssm'))
stsm        = ssm_stsm('trend', 'dummy', 12);
%stsm        = ssm_stsm('trend', 'dummy', 12,'cycle');  %Alternative version that includes a cycle
[stsm logL] = estimate(y, stsm);
[alpha v] = statesmo(y, stsm);
a=y(49:end)'-alpha(3,49:end)';
v=squeeze(v(3,3,49:end)+v(4,4,49:end)-v(3,4,49:end)-v(4,3,49:end));
v=sqrt(v);
x=[datenum(2007,[1:12]',15);datenum(2008,[1:12]',15);datenum(2009,[1:12]',15);datenum(2010,[1:12]',15);datenum(2011,[1:12]',15);datenum(2012,[1:12]',15);datenum(2013,[1:4]',15)];

axes=axes('Fontsize',12);
plot(x,v,'Linewidth',2)
datetick('x','mmmyy');
axis([datenum(2006,12,15) datenum(2013,5,15) 0 90])
set(gca,'linewidth',2);
ylabel('Employment (000s)','Fontsize',12);