function [f,mu,sigma] = snormpdf(x,Ex,Sx,tau)
% snormpdf  Probability density function for univariate split normal
% distribution.

% The IRIS Toolbox.
% Copyright 2007-2009 Jaromir Benes.

%**************************************************************************

% x ~ N(mu,sigma) for x <= mu
% x ~ N(mu,tau*sigma) for x > mu
    
    Sx2 = Sx^2;
    b = (pi-2)/pi*(tau - 1)^2 + tau;
    sigma2 = Sx2/b;
    sigma = sqrt(sigma2);
    mu = Ex - sqrt(2/pi)*sigma*(tau - 1);
    
    f = nan(size(x));
    if ~isempty(x)
        index = x <= mu;
        f(index) = 1/(1+tau)*normpdf(x(index),mu,sigma);
        f(~index) = tau/(1+tau)*normpdf(x(~index),mu,tau*sigma);
    end
    
end