function y = shift(x,s)

% The IRIS Toolbox.
% Copyright 2007-2009 Jaromir Benes.

if nargin < 2
   s = -1;
end

%**************************************************************************

xsize = size(x);
x = x(:,:);
nx = size(x,2);
y = [];
for k = s(:).'
   if k > 0
      tmp = [x(1+k:end,:);NaN*ones([k,nx])];
   elseif k < 0
      tmp = [NaN*ones([-k,nx]);x(1:end+k,:)];
   else
      tmp = x;
   end
   y = [y,reshape(tmp,xsize)];
end

end
