function printmsg(class,type,msg,list,code)
% Print error and warning messages.

% The IRIS Toolbox.
% Copyright 2007-2012 Jaromir Benes.

%**************************************************************************

if strcmp(type,'warning') && ~iswarning(class)
   return
end

if ~iscell(list)
   list = {list};
end

ref = sprintf('<%s:%s code="%02g"/>',lower(class),lower(type),code);
id = sprintf('IRIS:%s',class);
body = sprintf(['*** ',msg,'\n'],list{:});
body = body(1:end-1);
body = regexprep(body,'<<(.+) (.+)>>','<a href="$1">$2</a>');
body = regexprep(body,'<<(.*?)>>','<a href="">$1</a>');

stack = dbstack('-completenames');
% Get the IRIS root directory name.
[ans,irisfolder] = fileparts(irisget('irisroot'));
% Exclude functions contained in the IRIS root directory.
omit = 0;
nstack = length(stack);
while omit < nstack && ~isempty(strfind(stack(omit+1).file,irisfolder))
   omit = omit + 1;
end
stack(1:omit-1) = [];

if strcmp(type,'warning')
   % Throw a warning with dbstack report on non-iris function calls.
   aux = warning('query','backtrace');
   warning('off','backtrace');
   msg = sprintf('<a href="">The IRIS Toolbox Warning %s.</a>\n%s', ...
      ref,body);
   disp(msg);
   dbstack(omit);
   disp(' ');  
   lastwarn(msg,id);
   warning(aux.state,'backtrace');
else
   % Throw an error with stack of non-iris function calls.
   if isempty(stack)
      stack = struct('file','','name','','line',NaN);
   end
   tmp = struct();
   tmp.message = sprintf('The IRIS Toolbox Error %s.\n%s',ref,body);
   tmp.identifier = id;
   tmp.stack = stack;
   error(tmp);
end

end
