function [rad,per] = frf2phase(F,varargin)
% frf2phase  Phase shift of frequence response function.
%
% Syntax
% =======
%
%     [RAD,PER] = frf2phase(F)
%
% Input arguments
% ================
%
% * `F` [ numeric ] - Frequency response matrices computed by `ffrf`.
%
% Output arguments
% =================
%
% * `RAD` [ numeric ] - Phase shift in radians.
%
% * `PER` [ numeric ] - Phase shift in periods.
%
% Options
% ========
%
% See help on `xsf2phase` for options available.
%
% Description
% ============
%
% Example
% ========
%

% The IRIS Toolbox.
% Copyright 2007-2009 Jaromir Benes.

%**************************************************************************

isnamed = isa(F,'namedmat');
if isnamed
    row = rownames(F);
    col = colnames(F);
end

[rad,per] = xsf2phase(F,varargin{:});

if isnamed
    rad = namedmat(rad,row,col);
    per = namedmat(per,row,col);
end

end
