function F = frf2gain(F,varargin)
% frf2gain  Gain of frequency response function.
%
% Syntax
% =======
%
%     G = frf2gain(F)
%
% Input arguments
% ================
%
% * `F` [ numeric ] - Frequency response function.
%
% Output arguments
% =================
%
% * `G` [ numeric ] - Gain of frequency response function.
%
% Description
% ============
%
% Example
% ========
%

% The IRIS Toolbox 2009/07/11.
% Copyright 2007-2009 Jaromir Benes.

%********************************************************************

isnamed = isa(F,'namedmat');

if isnamed
    row = rownames(F);
    col = colnames(F);
end
    
F = abs(F);

if isnamed
    F = namedmat(F,row,col);
end

end
