function varargout = irispathmanager(action,varargin)
% irispathmanager  IRIS path manager.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************
    
    % Folders not to be included in the Matlab path.
    exclude = {'-','\+','\.'};
    
    switch lower(action)
        case 'cleanup'
            % Remove all IRIS roots and subs found on the Matlab temporary
            % and permanent search paths.
            varargout{1} = {};
            list = which('irisstartup.m','-all');
            for i = 1 : numel(list)
                root = fileparts(list{i});
                if isempty(root)
                    continue
                end
                [root,subs] = irispathmanager_genpathcell(root,exclude);
                if root(end) == pathsep()
                    root(end) = '';
                end
                if ~isempty(subs)
                    irispathmanager_rmperm(subs{:});
                    irispathmanager_rmtemp(subs{:});
                end
                if ~isempty(root)
                    irispathmanager_rmperm(root);
                    irispathmanager_rmtemp(root);
                end
                varargout{1}{end+1} = root;
            end
            clear('functions');
            rehash();
        case 'addroot'
            % Add the specified root to both the temporary and permanent
            % search paths.
            irispathmanager_addperm(varargin{1});
            addpath(varargin{1},'-begin');
        case 'addcurrentsubs'
            % Add subfolders within the current root to the temporary
            % search path.
            root = which('irisstartup.m');
            root = fileparts(root);
            [root,subs] = irispathmanager_genpathcell(root,exclude); %#ok<ASGLU>
            if isempty(subs)
                subs = '';
            else
                subs = [subs{:}];
                addpath(subs,'-begin');
            end
            varargout{1} = subs;
        case 'removecurrentsubs'
            % Remove subfolders within the current root from the temporary
            % and permanent search paths.
            root = which('irisstartup.m');
            root = fileparts(root);
            [root,subs] = irispathmanager_genpathcell(root,exclude); %#ok<ASGLU>
            if isempty(subs)
                subs = '';
            else
                subs = [subs{:}];
                irispathmanager_rmperm(subs);
                irispathmanager_rmtemp(subs);
            end
            varargout{1} = subs;
    end
    
end

%%
function irispathmanager_rmtemp(varargin)
    status = warning('query','all');
    warning('off','MATLAB:rmpath:DirNotFound');
    rmpath([varargin{:}]);
    warning(status);
end
% irispathmanager_rmtemp

%%
function flag = irispathmanager_rmperm(varargin)
    status = warning('query','all');
    warning('off','MATLAB:rmpath:DirNotFound');
    % * Remember the current temporary search path.
    % * Reset the default permanent search path.
    % * Remove `varargin`s from the permanent search path.
    % * Save the new permanent search path.
    % * Bring back the temporary search path.
    p = path();
    path(pathdef());
    rmpath([varargin{:}]);
    flag = savepath();
    path(p);
    warning(status);
end
% irispathmanager_rmperm

%%
function flag = irispathmanager_addperm(varargin)
    status = warning('query','all');
    warning('off','MATLAB:rmpath:DirNotFound');
    % * Remember the current temporary search path.
    % * Reset the default permanent search path.
    % * Add `varargin`s to the permanent search path.
    % * Save the new permanent search path.
    % * Bring back the temporary search path.
    p = path();
    path(pathdef());
    addpath([varargin{:}],'-begin');
    flag = savepath();
    path(p);
    warning(status);
end
% irispathmanager_addperm

%%
function [root,p] = irispathmanager_genpathcell(root,exclude)
    % Use `genpath` to generate path string and remove paths that include
    % patterns specified in `exclude`.
    p = genpath(root);
    if isempty(p)
        p = {};
        return
    else
        % Break the path string into individual paths.
        p = regexp(p,['.*?',pathsep()],'match');
        if isempty(p)
            return
        else
            root = p{1};
            p = p(2:end);
        end
    end
    
    if nargin > 1 && ~isempty(exclude) && ~isempty(p)
        if ischar(exclude)
            exclude = {exclude};
        end
        keep = true(size(p));
        % Length of the root string including the pathsep() at the end of it.
        % Later we remove `lenroot-1` characters from the individual paths.
        lenroot = length(root);
        for i = 1 : length(p)
            % Remove the root from the i-th path, and only check for the
            % excluded patterns in the rest of the path. This is to handle
            % cases in which the root includes some of the excluded patterns
            % (we don't want to remove the root then).
            dirname = p{i};
            if length(dirname) >= lenroot ...
                    && strncmpi(dirname,root,lenroot-1)
                dirname(1:lenroot-1) = '';
            end
            for j = 1 : length(exclude)
                keep(i) = keep(i) ...
                    && isempty(regexp(dirname,exclude{j},'once'));
                if ~keep(i)
                    break
                end
            end
        end
        p = p(keep);
    end
end
% irispathmanager_genpathcell