function d = dbredate(d,olddate,newdate)
% dbredate  Redate all tseries objects in a database.
%
% Syntax
% =======
%
%     d = redate(d,oldDate,newDate)
%
% Input arguments
% ================
%
% * `d` [ struct ] - Input database with tseries objects.
%
% * `oldDate` [ numeric ] - Base date that will be converted to a new date
% in all tseries objects.
%
% * `newDate` [ numeric ] - A new date to which the base date `oldDate`
% will be changed in all tseries objects; `newDate` can need not be the
% same frequency as `oldDate`.
%
% Output arguments
% =================
%
% * `d` [ struct ] - Output database where all tseries objects have
% identical data as in the input database, but with their time dimension
% changed.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

P = inputParser();
P.addRequired('d',@isstruct);
P.addRequired('oldDate',@isnumericscalar);
P.addRequired('newDate',@isnumericscalar);
P.parse(d,olddate,newdate);

%**************************************************************************

list = fieldnames(d);
tseriesIndex = structfun(@istseries,d);
structIndex = structfun(@isstruct,d);

% Cycle over all tseries objects.
for i = find(tseriesIndex.')
   d.(list{i}) = redate(d.(list{i}),olddate,newdate);
end

% Call recusively `dbclip` on sub-databases.
for i = find(structIndex.')
   d.(list{i}) = dbredate(d.(list{i}),range);
end

end