function varargout = dbcol(this,varargin)
% dbcol  Retrieve the specified column or columns from database entries.
%
% Syntax
% =======
%
%     d = dbcol(d,k)
%
% Input arguments
% ================
%
% * `d` [ struct ] - Input database with (possibly) multivariate tseries
% objects and numeric arrays.
%
% * `k` [ numeric | logical | 'end' ] - Column or columns that will be
% retrieved from each tseries object or numeric array and returned in the
% output database.
%
% Output arguments
% =================
%
% * `d` [ struct ] - Output database with tseries objects and numeric
% arrays reduced to the specified column.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.
    
    % Handle multiple input/output arguments.
    if length(varargin) > 1
        varargout = cell(size(varargin));
        for i = 1 : length(varargin)
            varargout{i} = dbcol(this,varargin{i});
        end
        return
    end
    
    % Single input/output argument from here on.
    index = varargin{1};
    list = fieldnames(this);
    if isempty(list)
        varargout{1} = this;
        return
    end
    if ischar(index) && strcmp(index,'end')
        index = length(this.(list{1}));
    end
    
%**************************************************************************
    
    for i = 1 : length(list)
        if istseries(this.(list{i}))
            try
                this.(list{i}) = this.(list{i}){:,index};
            end
        elseif isnumeric(this.(list{i})) ...
                || islogical(this.(list{i})) ...
                || iscell(this.(list{i}))
            try
                this.(list{i}) = this.(list{i})(:,index);
            end
        end
    end
    varargout{1} = this;
    
end