function dat = qqtoday()
% qqtoday  IRIS serial date number for current quarter.
%
% Syntax
% =======
%
%     d = qqtoday()
%
% Output arguments
% =================
%
% * `d` [ numeric ]  - IRIS serial date number for current quarter.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[year,month] = datevec(now());
dat = qq(year,1+floor((month-1)/3));

end
