function dat = hhtoday()
% hhtoday  IRIS serial date number for current half-year.
%
% Syntax
% =======
%
%     d = hhtoday()
%
% Output arguments
% =================
%
% * `d` [ numeric ] - IRIS serial date number for current half-year.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[year,month] = datevec(now());
dat = zz(year,1+floor((month-1)/6));

end