function flag = freqcmp(x,y)
% freqcmp  Compare date frequencies.
%
% Syntax
% =======
%
%     flag = freqcmp(d1,d2)
%
% Input arguments
% ================
%
% * `d1`, `d2` [ numeric ] - IRIS serial date numbers.
%
% Output arguments
% =================
%
% * `flag` [ `true` | `false` ] - True for dates of the same frequency.

% -IRIS Toolbox.
% -Copyright (c) 2007-2009 Jaromir Benes.

%**************************************************************************

xinf = isinf(x);
yinf = isinf(y);

fx = x - floor(x);
fx(xinf) = Inf;
fy = y - floor(y);
fy(yinf) = Inf;

flag = abs(fx - fy) < 1e-2 | isinf(fx - fy);

end
