function d2 = convert(d1,f2,varargin)
% CONVERT   Convert dates to another frequency.
%
% Syntax
% =======
%
%     D2 = convert(D1,NEWFREQ,...)
%
% Input arguments
% ================
%
% * `D1` [ numeric ] - IRIS serial date numbers that will be converted to
% the new frequency, `newfreq`.
%
% * `NEWFREQ` [ `0` | `1` | `2` | `4` | `6` | `12` ] - New frequency to
% which the dates `d1` will be converted.
%
% - Output arguments
%
% * `D2` [ numeric ] - IRIS serial date numbers representing the new
% frequency.
%
% Options
% ========
%
% * `'standinMonth='` [ numeric | `'last'` | *`1`* ] - Which month will be
% used to represent a certain period of time in low- to high-frequency
% conversions.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright 2007-2012 Jaromir Benes.

% Parse options.
options = passvalopt('dates.convert',varargin{:});

config = irisget();
if isequal(options.standinmonth,'config')
   options.standinmonth = config.standinmonth;
end

%**************************************************************************

% Get year, period, and frequency of the original dates.
[y1,p1,f1] = dat2ypf(d1);

% First, convert the original period to a corresponding month.
m = per2month(p1,f1,options.standinmonth);

% Then, convert the month to the corresponding period of the request
% frequnecy.
p2 = ceil(m.*f2./12);

% Create the new serial date number.
d2 = datcode(f2,y1,p2);

end
