% dates  Dates and date ranges.
%
% Creating IRIS serial date numbers
% ==================================
%
% * [`bb`](dates/bb) - IRIS serial date numbers for dates with bi-monthly frequency.
% * [`bbtoday`](dates/bbtoday) - IRIS serial date number for current bi-month.
% * [`hh`](dates/hh) - IRIS serial date numbers for dates with half-yearly frequency.
% * [`hhtoday`](dates/hhtoday) - IRIS serial date number for current half-year.
% * [`mm`](dates/mm) - IRIS serial date numbers for dates with monthly frequency.
% * [`mmtoday`](dates/mmtoday) - IRIS serial date number for current month.
% * [`qq`](dates/qq) - IRIS serial date numbers for dates with quarterly frequency.
% * [`qqtoday`](dates/qqtoday) - IRIS serial date number for current quarter.
% * [`yy`](dates/yy) - IRIS serial date numbers for dates with yearly frequency.
% * [`yytoday`](dates/yytoday) - IRIS serial date number for current year.
%
% Computing special dates (daily dates only)
% ===========================================
%
% * [`datbom`](dates/datbom) - Beginning of month for the specified daily date.
% * [`datboq`](dates/datboq) - Beginning of quarter for the specified daily date.
% * [`datboy`](dates/datboy) - Beginning of year for the specified daily date.
% * [`dateom`](dates/dateom) - End of month for the specified daily date.
% * [`dateoq`](dates/dateoq) - End of quarter for the specified daily date.
% * [`dateoy`](dates/dateoy) - End of year for the specified daily date.
%
% Creating date ranges
% =====================
%
% * [`daterange`](dates/daterange) - Use the colon operator to create date ranges.
%
% Converting dates
% =================
%
% * [`clp2dat`](dates/clp2dat) - Convert text in system clipboard to dates.
% * [`dat2char`](dates/dat2char) - Convert dates to character array.
% * [`dat2charlist`](dates/dat2charlist) - Convert dates to a comma-separated list.
% * [`dat2clp`](dates/dat2clp) - Convert dates to text and paste to system clipboard.
% * [`dat2dec`](dates/dat2dec) - Convert dates to their decimal representations.
% * [`dat2str`](dates/dat2str) - Convert IRIS dates to cell array of strings.
% * [`dat2ypf`](dates/dat2ypf) - Convert IRIS serial date number to year, period and frequency.
% * [`dec2dat`](dates/dec2dat) - Convert decimal numbers to IRIS serial date numbers.
% * [`str2dat`](dates/str2dat) - Convert strings to IRIS serial date numbers.
%
% Date comparison
% ================
%
% * [`datcmp`](dates/datcmp) - Compare two IRIS serial date numbers.
% * [`datdiff`](dates/datdiff) - Number of periods between two dates with check for date frequency.
% * [`rngcmp`](dates/rngcmp) - Compare two IRIS date ranges.
%
% Getting on-line help on date functions
% =======================================
%
%     help dates
%     help dates/function_name
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.
