classdef codecreator < handle
    
    properties
        code = '';
        indentString = '   ';
        autoIndent = 0;
    end
    
    methods
        function this = codecreator(varargin)
            if ~isempty(varargin)
                this.indentString = varargin{1};
            end
        end
        function this = nl(this,varargin)
            if isempty(varargin) || ~isnumericscalar(varargin{1})
                nNl = 1;
            else
                nNl = varargin{1};
            end
            nl = sprintf('\n');
            this.code = [this.code,nl(ones([1,nNl]))];
        end
        function [this,varargin] = indent(this,varargin)
            if isempty(varargin) || ~isnumericscalar(varargin{1})
                nIndent = 1;
            else
                nIndent = varargin{1};
                varargin(1) = [];
            end
            for i = 1 : nIndent
                this.code = [this.code,this.indentString];
            end
        end
        function this = print(this,varargin)
            if this.autoIndent > 0
                this = indent(this,this.autoIndent);
            end
            if length(varargin) == 1
                this.code = [this.code,varargin{1}];
            else
                this.code = [this.code,sprintf(varargin{:})];
            end
        end
        function this = printn(this,varargin)
            this = print(this,varargin{:});
            this = nl(this);
        end
        function this = nprint(this,varargin)
            this = nl(this);
            this = print(this,varargin{:});
        end
        function this = iprint(this,varargin)
            [this,varargin] = indent(this,varargin{:});
            this = print(this,varargin{:});
        end
        function this = iprintn(this,varargin)
            [this,varargin] = indent(this,varargin{:});
            this = print(this,varargin{:});
            this = nl(this);
        end
        function this = niprint(this,varargin)
            this = nl(this);
            [this,varargin] = indent(this,varargin{:});
            this = print(this,varargin{1});
        end
        function save(this,filename)
            strfun.char2file(this.code,filename);
        end
    end
    
end