function varargout = userdatafield(THIS,FIELD,varargin)
% userdatafield  Getting and setting userdata field.
%
% Syntax for getting userdata field
% ==================================
%
%     X = userdatafield(OBJ,FIELD)
%
% Syntax for assigning userdata field
% ====================================
%
%     OBJ = userdatafield(OBJ,FIELD,X)
%
% Input arguments
% ================
%
% * `OBJ` [ model | tseries | VAR | SVAR | FAVAR | sstate ] -
% One of the IRIS objects.
%
% * `FIELD` [ char ] - Field of the userdata struct; if userdata is empty,
% the field can be created.
%
% * `X` [ ... ] - Data that will be stored in field `FIELD` of the userdata
% struct.
%
% Output arguments
% =================
%
% * `X` [ ... ] - Field `FIELD` of the userdata struct that are currently
% attached to the object.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if isempty(varargin)
    u = THIS.UserData;
    if isa(u,'struct') && isfield(u,FIELD)
        varargout{1} = u.(FIELD);
    else
        utils.error('userdata', ...
            ['User data is not a struct, ', ...
            'or the field ''%s'' does not exist.'], ...
            FIELD);
    end
else
    u = THIS.UserData;
    if isempty(u) || isstruct(u)
        THIS.UserData.(FIELD) = varargin{1};
    else
        utils.error('userdata', ...
            'User data is non-empty and not a struct .');
    end
    varargout{1} = THIS;
end

end