function varargout = userdata(this,varargin)
% userdata  Get or set user data in an IRIS object.
%
% Syntax for getting user data
% =============================
%
%     X = userdata(OBJ)
%
% Syntax for assigning user data
% ===============================
%
%     OBJ = userdata(OBJ,X)
%
% Input arguments
% ================
%
% * `OBJ` [ model | tseries | VAR | SVAR | FAVAR | sstate ] -
% One of the IRIS objects.
%
% * `X` [ ... ] - Data that will be attached to the object.
%
% Output arguments
% =================
%
% * `X` [ ... ] - User data that are currently attached to the
% object.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if isempty(varargin)
    varargout{1} = this.UserData;
else
    this.UserData = varargin{1};
    varargout{1} = this;
end

end