function [x,varargout] = unop(func,x,dim,varargin)
% unop  [Not a public function] Unary operators and functions on tseries objects.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if dim == 0
    % Returns tseries of the same size.
    tmpsize = size(x.data);
    if ischar(func)
        [x.data,varargout{1:nargout-1}] = ...
            feval(func,x.data(:,:),varargin{:});
    else
        [x.data,varargout{1:nargout-1}] = func(x.data(:,:),varargin{:});
    end
    if length(tmpsize) > 2
        x.data = reshape(x.data,[size(x.data,1),tmpsize(2:end)]);
    end
    if ~isempty(x.data) && any(any(isnan(x.data([1,end],:))))
        x = mytrim(x);
    end
elseif dim == 1
    % Returns numeric array as a result of applying FUNC in 1st dimension
    % (time).
    if ischar(func)
        [x,varargout{1:nargout-1}] = feval(func,x.data,varargin{:});
    else
        [x,varargout{1:nargout-1}] = func(x.data,varargin{:});
    end
else
    % Returns a tseries shrunk in DIM as a result of applying FUNC in that
    % dimension
    if ischar(func)
        [x.data,varargout{1:nargout-1}] = feval(func,x.data,varargin{:});
    else
        [x.data,varargout{1:nargout-1}] = func(x.data,varargin{:});
    end
    dim = size(x.data);
    x.Comment = cell([1,dim(2:end)]);
    x.Comment(:) = {''};
    if ~isempty(x.data) && any(any(isnan(x.data([1,end],:))))
        x = mytrim(x);
    end
end

end