function varargout = scatter(varargin)
% scatter  Scatter graph for tseries objects.
%
% Syntax
% =======
%
%     [h,range] = scatter([x,y],...)
%     [h,range] = scatter(range,[x,y],...)
%     [h,range] = scatter(a,range,[x,y],...)
%
% Input arguments
% ================
%
% * `a` [ numeric ] - Handle to axes in which the graph will be plotted; if
% not specified, the current axes will used.
%
% * `range` [ numeric ] - Date range; if not specified the entire range of
% the input tseries object will be plotted.
%
% * `x`, `y` [ tseries ] - Two scalar tseries objects plotted on the x-axis
% and the y-axis, respectively.
%
% Output arguments
% =================
%
% * `h` [ numeric ] - Handles to the lines plotted.
%
% * `range` [ numeric ] - Actually plotted date range.
%
% Options
% ========
%
% * `'dateformat='` [ char | *irisget('plotdateformat')* ] - Date format for
% the tick marks on the x-axis.
%
% * `'datetick='` [ numeric | *`Inf`* ] - Vector of dates locating tick marks
% on the x-axis; Inf means they will be created automatically.
%
% See help on built-in `plot` function for other options available.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% AREA, BAR, PLOT, CONBAR, PLOTCMP, PLOTYY, STEM, SCATTER

% TODO: Add help on date format related options.

%**************************************************************************

[varargout{1:nargout}] = tseries.gplot(@scatter,varargin{:});

end
