function x = round(x,decimals)
% round  Round tseries data to specified number of decimals.
%
% Syntax
% =======
%
%     x = round(x)
%     x = round(x,dec)
%
% Input arguments
% ================
%
% * `x` [ tseries ] - Tseries object whose data will be rounded.
%
% * `dec` [ numeric ] - Number of decimals to which the tseries data will
% be rounded; if not specified, the data are rounded to nearest integer.
%
% Output arguments
% =================
%
% * `x` [ tseries ] - Rounded tseries object.
%
% Description
% ============
%
% The number of decimals, to which the tseries data will be rounded, can be
% positive, zero, or negative.
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) Jaromir Benes.

if ~exist('decimals','var')
    decimals = 0;
end

%**************************************************************************

if decimals ~= 0
    factor = 10^decimals;
    x.data = x.data * factor;
end
x.data = round(x.data);
if decimals ~= 0
    x.data = x.data / factor;
end

end
