function this = permute(this,order)
% permute  Permute dimensions of a tseries object.
%
% Syntax
% =======
%
%     X = permute(X,ORDER)
%
% Input arguments
% ================
%
% * `X` [ tseries ] - Tseries object whose dimensions, except the first
% (time) dimension, will be rearranged in the order specified by the vector
% `order`.
%
% * `ORDER` [ numeric ] - New order of dimensions; because the time
% dimension cannot be permuted, `order(1)` must be always `1`.
%
% Output arguments
% =================
%
% * `X` [ tseries ] - Output tseries object with its dimensions permuted.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

P = inputParser();
P.addRequired('x',@(x) isa(x,'tseries'));
P.addRequired('order',@(x) isnumeric(x) && ~isempty(x) && x(1) == 1);
P.parse(this,order);

%**************************************************************************

this.data = permute(this.data,order);
this.Comment = permute(this.Comment,order);

end
