function a = pct(x,s)
% pct  Percent rate of change.
%
% Syntax
% =======
%
%     x = pct(x)
%     x = pct(x,k)
%
% Input arguments
% ================
%
% * `x` [ tseries ] - Input tseries object.
%
% * `k` [ numeric ] - Time shift over which the rate of change will be
% computed, i.e. between time t and t+k; if not specified `k` will be set
% to -1.
%
% Output arguments
% =================
%
% * `x` [ tseries ] - Percentage rate of change in the input data.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if nargin < 2
    s = -1;
end

%**************************************************************************

a = unop(@tseries.mypct,x,0,s,1);

end
