function x = mytrim(x)
% MYTRIM  [Not a public function] Remove leading and trailing NaNs.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if isempty(x.data)
    return
end

if isreal(x.data)
    testfornan = @isnan;
else
    testfornan = @(x) isnan(real(x)) & isnan(imag(x));
end

if ~any(any(testfornan(x.data([1,end],:))))
    return
end

nanindex = all(testfornan(x.data(:,:)),2);
newsize = size(x.data);
if all(nanindex)
    x.start = NaN;
    newsize(1) = 0;
    x.data = zeros(newsize);
else
    first = find(~nanindex,1);
    last = find(~nanindex,1,'last');
    x.data = x.data(first:last,:);
    newsize(1) = last - first + 1;
    x.data = reshape(x.data,newsize);
    x.start = x.start + first - 1;
end

end
