function [low,high] = myhpdi(x,prob,dim)
% MYHPDI  [Not a public function] Highest probability density interval.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes & Troy Matheson.

%**************************************************************************

prob = prob/100;

x = x(:,:);

if dim == 1
    x = x.';
end

% Proceed row by row.
[nper,ndraw] = size(x);
w = round((1-prob)*ndraw);
low = nan(nper,1);
high = nan(nper,1);
for t = 1 : nper
    x(t,:) = sort(x(t,:),2);
    distance = x(t,end-w:end) - x(t,1:w+1);
    [mindistance,pos] = min(distance);
    low(t,:) = x(t,pos(1));
    high(t,:) = x(t,pos(1)) + mindistance;
end

if dim == 1
    low = low.';
    high = high.';
end

end