function this = init(this,dates,data)
% INIT  [Not a public function] Create start date and data for new tseries object.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if isa(data,'single')
    prec = 'single';
else
    prec = 'double';
end

dates = dates(:);
nper = length(dates);
nobs = size(data,1);
datasize = size(data);
if nobs == 0 && (all(isnan(dates)) || nper == 0)
    datasize(1) = 0;
    this.start = NaN;
    this.data = zeros(datasize,prec);
    return
end

if datasize(1) ~= nper
    utils.error('tseries', ...
        'Number of dates and number of rows of data must match.');
end

data = data(:,:);

% Remove NaN dates.
nandates = isnan(dates);
if any(nandates)
    data(nandates,:) = [];
    dates(nandates) = [];
end

% Start date is the minimum date found.
start = min(dates);

% Number of proper dates.
nper = round(max(dates) - start + 1);
if isempty(nper)
    nper = 0;
end

datasize(1) = nper;

% Assign data points at proper dates.
this.data = nan(datasize,prec);
pos = round(dates - start + 1);

% Assign user data to tseries object; note that higher dimensions will be
% preserved in `this.data`.
this.data(pos,:) = data;
this.start = start;

end