function disp(THIS,NAME,DISP2D)
% DISP  [Not a public function] Disp method for tseries objects.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if nargin < 2
   NAME = '';
end

if nargin < 3
   DISP2D = @xxdisp2ddefault;
end

%**************************************************************************

mydispheader(THIS);

start = THIS.start;
data = THIS.data;
xxdispnd(start,data,THIS.Comment,[],NAME,DISP2D,ndims(data));
disp@userdataobj(THIS);
disp(' ');

end

% Subfunctions.

%**************************************************************************
function xxdispnd(START,DATA,COMMENT,POSITION,NAME,DISP2D,NDIM) 
   lastDimSize = size(DATA,NDIM);
   nper = size(DATA,1);
   if NDIM > 2
      subsref = cell([1,NDIM]);
      subsref(1:NDIM-1) = {':'};
      for i = 1 : lastDimSize
         subsref(NDIM) = {i};
         xxdispnd(START,DATA(subsref{:}),COMMENT(subsref{:}), ...
            [i,POSITION],NAME,DISP2D,NDIM-1);
      end
   else
      if ~isempty(POSITION)
         fprintf('%s{:,:%s} =\n',NAME,sprintf(',%g',POSITION));
         strfun.loosespace();
      end
      if nper > 0
         [dates,DATA] = DISP2D(START,DATA);
         try
            datastr = num2str(DATA,irisget('tseriesformat'));
         catch %#ok<CTCH>
            datastr = num2str(DATA);
         end
         disp([dates,datastr]);
      end
      disp(COMMENT);
   end
end
% xxdispnd().

%**************************************************************************
function [dates,DATA] = xxdisp2ddefault(START,DATA)
   nPer = size(DATA,1);
   range = START + (0 : nPer-1);
   tab = sprintf('\t');
   sep = sprintf(': ');
   dates = [ ...
      tab(ones([1,nPer]),:), ...
      strjust(dat2char(range)),sep(ones([1,nPer]),:), ...
   ];
end
% xxdisp2ddefault().