function x = diff(x,k)
% diff  First difference.
%
% Syntax
% =======
%
%     Y = diff(X)
%     Y = diff(X,K)
%
% Input arguments
% ================
%
% * `X` [ tseries ] - Input tseries object.
%
% * `K` [ numeric ] - Number of periods over which the first difference
% will be computed; Y = X - X{K}. Note that `K` must be a negative number
% for the usual backward differencing. If not entered, the default `-1`
% will be used.
%
% Output arguments
% =================
%
% * `Y` [ tseries ] - First difference of the input data.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% DIFF, DF, PCT, APCT

if nargin < 2
    k = -1;
end

P = inputParser();
P.addRequired('x',@istseries);
P.addRequired('k',@isnumericscalar);
P.parse(x,k);

%**************************************************************************

x = unop(@tseries.mydiff,x,0,k);

end