function x = destdise(x,xmean,xstd)
% destdise  Destandardise tseries object by applying specified standard deviation and mean to it.
%
% Syntax
% =======
%
%     X = destdise(X,XMEAN,XSTD)
%
% Input arguments
% ================
%
% * `X` [ tseries ] - Input tseries object.
%
% * `XMEAN` [ numeric ] - Mean that will be added the data.
%
% * `XSTD` [ numeric ] - Standard deviation that will be added to the data.
%
% Output arguments
% =================
%
% * `X` [ tseries ] - Destandardised output data.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

IP = inputParser();
IP.addRequired('X',@istseries);
IP.addRequired('XMEAN',@isnumeric);
IP.addRequired('XSTD',@isnumeric);
IP.parse(x,xmean,xstd);

%**************************************************************************

% Check size conformity.
s1 = size(x);
s2 = size(xmean);
s3 = size(xstd);

if any(s1(2:end) ~= s2(2:end))
    utils.error('tseries', ...
        'Size of input data and mean must agree in 2nd and higher dimensions.');
end

if any(s1(2:end) ~= s3(2:end))
    utils.error('tseries', ...
        'Size of input data and std devs must agree in 2nd and higher dimensions.');
end

x = unop(@tseries.mydestdize,x,0,xmean,xstd);

end