function a = apct(x,q)
% apct  Annualised percent rate of change.
%
% Syntax
% =======
%
%     x = apct(x)
%
% Input arguments
% ================
%
% * `x` [ tseries ] - Input tseries object.
%
% Output arguments
% =================
%
% * `x` [ tseries ] - Annualised percentage rate of change in the input
% data.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if ~exist('q','var')
    q = get(x,'freq');
    if q == 0
        q = 1;
    end
end

a = unop(@tseries.mypct,x,0,-1,q);

end