function THIS = syeq(THIS)
% syeq [Not a public function] Initialise theta parser object for syeq class.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

THIS.caller = 'syeq';

THIS.blkname = {...
    '!endogenous_variables', ...     1
    '!exogenous_variables', ...      2
    '!shocks', ...                   3
    '!parameters', ...               4
    '!log_variables', ...            5
    '!equations', ...                6
    '!userdiff', ...                 7
    };

nblk = length(THIS.blkname);

THIS.nameblk = false(1,nblk);
THIS.nameblk([1,2,3,4]) = true;

THIS.eqtnblk = false(1,nblk);
THIS.eqtnblk(6) = true;

THIS.flagblk = false(1,nblk);
THIS.flagblk(5) = true;

% Name blocks whose names can be referred to in flag blocks.
THIS.flaggable = false(1,nblk);
THIS.flaggable([1,2]) = true;

% Blocks that cannot remain empty.
THIS.essential = false(1,nblk);
THIS.essential([1,6]) = true;

THIS.altblkname = { ...
    '!variables','!endogenous_variables'; ...
    '!transition_variables','!endogenous_variables'; ...
    '!transition_equations','!equations'; ...
    '!transition_shocks','!shocks'; ...
    };

end