function THIS = altsyntax(THIS)

% Generic alt syntax.

% Steady-state reference $ -> &.
THIS.code = regexprep(THIS.code,'\$\<([a-zA-Z]\w*)\>(?!\$)','&$1');

% Specific alt syntax.

nblkwarn = size(THIS.altblknamewarn,1);
report = false(nblkwarn,1);
for i = 1 : nblkwarn
    if ~isempty(strfind(THIS.code,THIS.altblknamewarn{i,1}))
        THIS.code = strrep(THIS.code, ...
            THIS.altblknamewarn{i,1},THIS.altblknamewarn{i,2});
        report(i) = true;
    end
end

% Create a cellstr {obsolete,new,obsolete,new,...}.
report = THIS.altblknamewarn(report,:).';
report = report(:).';

% Alternative or short-cut syntax, do not report.
naltblk = size(THIS.altblkname,1);
for i = 1 : naltblk
    THIS.code = regexprep(THIS.code, ...
        [THIS.altblkname{i,1},'(?=\s)'], ...
        THIS.altblkname{i,2});
end

if ~isempty(report)
    utils.warning('obsolete', [errorparsing(THIS), ...
        'The model file keyword ''%s'' is obsolete, ', ...
        'use ''%s'' instead.'], ...
        report{:});
end

end