classdef syeq < metaobj & userdataobj & estimateobj
    
    properties
        % User equations.
        eqtn = cell(1,0);
        eqtntype = zeros(1,0);
        eqtnlabel = cell(1,0);
        evalident = [];
        evalnonident = [];
        % List of functions with user derivatives.
        userdifflist = cell(1,0);
        % Full equations or RHS of identities.
        eqtnf = cell(1,0);
        occur = false(0);
        % Max lag and lead.
        mint = NaN;
        maxt = NaN;
        % Ids of LHS variables or shocks in transition equations.
        ident = zeros(1,0);
        % Derivatives of equations wrt to current dates of transition variables.
        deqtnx = cell(1,0);
        % Derivatives of equations wrt shocks.
        deqtne = cell(1,0);
    end
    
    methods
        
        function THIS = syeq(varargin)
            if isempty(varargin)
                return
            end
            if length(varargin) >= 1 ...
                    && (ischar(varargin{1}) || iscellstr(varargin{1}))
                fname = varargin{1};
                varargin(1) = [];
                opt = passvalopt('syeq.syeq',varargin{:});
                THIS = myparse(THIS,fname,opt);
                return
            end
        end
        
        varargout = chkinputdata(varargin)
        varargout = filter(varargin)
        varargout = get(varargin)
        varargout = disp(varargin)
        varargout = system(varargin)
        
    end
    
    methods (Hidden)
        varargout = lab(varargin)
        varargout = mydatarequest(varargin)
        varargout = mykalman(varargin)
        varargout = myfindoccur(varargin)
    end
    
    methods (Access=protected,Hidden)
        varargout = mybackoutshocks(varargin)
        varargout = myestimstruct(varargin)
        varargout = myevalident(varargin)
        varargout = myevalgroupfunc(varargin)

        varargout = myparse(varargin)
        varargout = mypreloglik(varargin)
        varargout = mypreoutput(varargin)
        varargout = myproposalcov(varargin)
    end
    
end