function [OPT,THIS,MLLFUNC] = mypreloglik(THIS,RANGE,~,TUNE,varargin)
% MYPRELOGLIK  [Not a public function] Prepare for likelihood function evaluation.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

nper = length(RANGE);
OPT = passvalopt('syeq.kalman',varargin{:});

% Filter function handle.
MLLFUNC = @mykalman;

% Time-varying stdcorr vector; 'clip' means the stdcorr vector will be cut
% at the last user-supplied period.
OPT.stdcorr = mytune2stdcorr(THIS,RANGE,TUNE,OPT,'clip');

% Range on which the objective function will be evaluated. The `'objrange='`
% option gives the range from which sample information will be used to
% calculate the objective function and estimate the out-of-lik parameters.
if isequal(OPT.objrange,Inf)
    OPT.objrange = true(1,nper);
else
    first = max(1,round(OPT.objrange(1) - RANGE(1) + 1));
    last = min(nper,round(OPT.objrange(end) - RANGE(1) + 1));
    OPT.objrange = false(1,nper);
    OPT.objrange(first : last) = true;
end

end