function [S,FILTEROPT] = myestimstruct(THIS,E,PEN,FILTEROPT,varargin)
% MYESTIMSTRUCT  [Not a public function] Parse structure with estimation specs.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox. 
% -Copyright (c) 2007-2012 Jaromir Benes.

iswarning = any(strcmp(varargin,'warning'));

%**************************************************************************

[S,E] = myparamstruct(THIS,E,PEN,varargin{:});

[FILTEROPT,E] = myxunobsstruct(THIS,E,FILTEROPT);

% Throw warning if there are names remaining in the estimation struct.
if iswarning
    dochkresidualnames();
end

%**************************************************************************
    function dochkresidualnames()
        f = fieldnames(E).';
        if ~isempty(f)
            utils.error('model', ...
                'This is not a valid name in estimation input struct: ''%s''.', ...
                f{:});
        end
    end
% dochkresidualnames().

end