function [X,XRANGE] = mydatarequest(~,THIS,DATA,RANGE,IDATA,OPT) %#ok<INUSD>

%**************************************************************************

nname = sum(THIS.nametype <= 3);
maxlag = -THIS.mint;
maxlead = THIS.maxt;
XRANGE = RANGE(1)-maxlag : RANGE(end)+maxlead;
nxper = length(XRANGE);

% Pre-allocate output data matrix; the matrix includes pre-sample and
% post-sample data, too.
X = nan(nname,nxper);

% Data for transition variables and shocks.
if isstruct(DATA)
    if isfield(DATA,'mean') && isstruct(DATA.mean)
        dogetdata(DATA.mean);
    else
        dogetdata(DATA);
    end
end

% Nested functions.

%**************************************************************************
    function dogetdata(INP)
        for ii = find(THIS.nametype <= 3)
            name = THIS.name{ii};
            if isfield(INP,name) && isa(INP.(name),'tseries')
                x = rangedata(INP.(name),XRANGE);
                x = x(:,:);
                x = x(:,min(end,IDATA));
                X(ii,:) = x.';
            end
        end
    end
% dogetdata().

end