function OUTP = evalident(THIS,INP,RANGE,varargin)
% evalident  Evaluate identities.
%
% Syntax
% =======
%
%     OUTP = evalident(M,INP,RANGE,...)
%
% Input arguments
% ================
%
% * `M` [ model ] - Solved model object.
%
% * `INP` [ struct | cell ] - Input database from which the non-identity
% variables will be taken.
%
% * `RANGE` [ numeric ] - Filter date range.
%
% Output arguments
% =================
%
% * `OUTP` [ struct | cell ] - Output database with identity variables
% evaluated.
%
% Options
% ========
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

P = inputParser();
P.addRequired('THIS',@(x) isa(x,'syeq'));
P.addRequired('INP',@(x) isstruct(x) || iscell(x) || isempty(x));
P.addRequired('RANGE',@isnumeric);
P.parse(THIS,INP,RANGE);

% This FILTER function options.
opt = passvalopt('syeq.evalident',varargin{:}); %#ok<NASGU>

%**************************************************************************

nalt = size(THIS.Assign,3);
ndata = 1;
NLOOP = max([nalt,ndata]);

% Preallocate output database.
OUTP = struct();
ppinitoutp;

for iloop = 1 : NLOOP
    
    idata = min(iloop,ndata);
    ialt = min(iloop,nalt);
    
    % Get an nname-by-nper matrix of current data.
    Y = mydatarequest([],THIS,INP,RANGE,idata);    
    
    % Run the filter.
    Y = permute(Y,[3,1,2]);
    time = Inf;
    select = Inf;
    Y = myevalident(THIS,Y,time,select,ialt);
    Y = ipermute(Y,[3,1,2]); %#ok<NASGU>
    
    % Y = mybackoutshocks(THIS,Y,ialt); %#ok<NASGU>
    
    % Add current filter data to output database.
    COLS = iloop; %#ok<NASGU>
    ppassignoutp;

end

% Convert output data to tseries objects.
ppconvertoutp;

end