function [FLAG,MISS] = chkinputdata(THIS,INP,RANGE,FUNC,varargin)

opt = passvalopt('syeq.chkinputdata',varargin{:});

%**************************************************************************

RANGE = RANGE(1) : RANGE(end);
FUNC = char(FUNC);

MISS = struct();

maxlag = -THIS.mint;
maxlead = THIS.maxt;
nt = size(THIS.occur,3);
tzero = 1 - THIS.mint;
neqtn = length(THIS.eqtn);
xrange = RANGE(1)-maxlag : RANGE(end)+maxlead;
nxper = length(xrange);

switch FUNC
    case 'filter'
        dofilter();
    otherwise
        utils.error('syeq', ...
            'Unknown function name in CHKINPUTDATA.');
end

FLAG = isempty(fieldnames(MISS));

% Nested functions.

    function dofilter()
        
        idata = 1;
        Y = mydatarequest([],THIS,INP,RANGE,idata);
        Y(THIS.log,:,:) = log(Y(THIS.log,:,:));
        L = real(THIS.Assign(1,:,idata));
        missvar = false(size(Y));
        misspar = false(size(L));
        t = 1+maxlag : nxper-maxlead;
        for ii = find(THIS.nametype <= 2);
            name = THIS.name{ii};
            occur = reshape(THIS.occur(:,ii,:),[neqtn,nt]);
            tmocc = find(any(occur,1)) - tzero;
            isident = any(THIS.ident == ii);
            for it = tmocc(:).'
                y = zeros(1,nxper);
                y(t+it) = Y(ii,t+it);
                if isident
                    y(t) = 0;
                end
                missvar(ii,isnan(y)) = true;
            end
            if any(missvar(ii,:))
                MISS.(name) = xrange(missvar(ii,:));
                if isequal(opt.dates,'char')
                    MISS.(name) = dat2str(MISS.(name));
                end
            end
        end
        for ii = find(THIS.nametype == 4)
            if ~any(any(THIS.occur(:,ii,:)))
                continue
            end
            name = THIS.name{ii};
            misspar(ii) = isnan(L(ii));
            if misspar(ii)
                MISS.(name) = NaN;
            end
        end
        
    end

end