function this = parse(func,varargin)
% parse  [Not a public function] Convert Matlab function to sydney object.
%
% Backend IRIS function.
% No help provided.

% The IRIS Toolbox.
% Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

try %#ok<TRYNC>
    x = builtin(func,varargin{:});
    if isnumeric(x)
        this = sydney(x);
        return
    end
end
n = length(varargin);
this = sydney();
this.func = func;
this.lookahead = cell(1,n);
a = varargin;
for i = 1 : n
    if isnumeric(varargin{i})
        value = varargin{i};
        a{i} = sydney();
        a{i}.func  = '';
        a{i}.args = value;
    elseif isa(varargin{i},'sydney')
        if isempty(varargin{i}.func) && ischar(varargin{i}.args)
            this.lookahead{i} = {varargin{i}.args};
        else
            this.lookahead{i} = [varargin{i}.lookahead{:}];
        end
    end
end
this.args = a;

end