function [eqtn,eqtn2] = mysymb2eqtn(eqtn)
% mysymb2eqtn  [Not a public function] Replace sydney representation of variables back with a variable array.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% Replace xN, xNpK, or xNmK back with x(:,N,t+/-K) or x(N,t+/-K).
% Replace Ln back with L(n).

% Make sure we only replace whole words not followed by an opening round
% bracket to avoid conflicts with function names.

if nargout == 1
    eqtn = regexprep(eqtn,'\<x(\d+)p(\d+)\>(?!\()','x(:,$1,t+$2)');
    eqtn = regexprep(eqtn,'\<x(\d+)m(\d+)\>(?!\()','x(:,$1,t-$2)');
    eqtn = regexprep(eqtn,'\<x(\d+)\>(?!\()','x(:,$1,t)');
    eqtn = regexprep(eqtn,'\<L(\d+)\>(?!\()','L($1)');
else
    eqtn = regexprep(eqtn,'\<x(\d+)p(\d+)\>(?!\()','x($1,t+$2)');
    eqtn = regexprep(eqtn,'\<x(\d+)m(\d+)\>(?!\()','x($1,t-$2)');
    eqtn = regexprep(eqtn,'\<x(\d+)\>(?!\()','x($1,t)');
    eqtn = regexprep(eqtn,'\<L(\d+)\>(?!\()','L($1)');
    eqtn2 = eqtn;
end

end