function [T,R,A,B,C] = system(this,a,x,t)

nt = size(this.occur,3);
maxlag = nt - 1;
n = sum(this.nametype == 1);
nname = length(this.name);
ne = sum(this.nametype == 3);

[oname,olag] = findoccur(this);
nd = length(oname);

D = zeros(n,nname,nt);
d = cellfun(@(f) f(a,x,t),this.dimplicit);
for ieq = 1 : n
    for id = 1 : nd
        % We don't need to treat log-variables any different, because the
        % derivatives of the equations wrt to log-variables have been
        % already adjusted in `parse`.
        D(ieq,oname(id),olag(id)+1) = d(ieq,id);
    end
end

nadd = n*(maxlag-1);

A = [D(:,this.nametype == 1,1),zeros(n,nadd); ...
    zeros(nadd,n),eye(nadd)];
A = A(this.systemkeep,this.systemkeep);

B = -D(:,this.nametype == 1,2:end);
B = [B(:,:);eye(nadd,nadd+n)];
B = B(this.systemkeep,this.systemkeep);

C = -D(:,this.nametype == 3,1);
C = [C;zeros(nadd,ne)];
C = C(this.systemkeep,:);

T = A\B;
R = A\C;

end