function varargout = subsref(this,s)
% subsref  Subscripted reference for rhsmodel objects.
%
% Syntax for retrieving rhsmodel object with subset of parameterisations
% =======================================================================
%
%     b(index)
%
% Syntax to retrieve a parameter or steady-state value
% =====================================================
%
%     b.name
%
% Input arguments
% ================
%
% * `b` [ rhsmodel ] - rhsmodel object.
%
% * `index` [ numeric | logical ] - Index of requested parameterisations.
%
% * `name` [ char ] - Name of a variable or parameter.
%
% Description
% ============
%
% Example
% ========

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if isequal(s(1).type,'()')
   index = s(1).subs{1};
   this.Assign = this.Assign(1,:,index);
   this.stdcorr = this.stdcorr(:,:,index);
   varargout{1} = this;
   s(1) = [];
elseif isequal(s(1).type,'.')
   name = s(1).subs;
   [assignpos,stdcorrpos] = mynameposition(this,name);
   if sum(assignpos) + sum(stdcorrpos) > 1
      % More than one name matches found; this is probably a regexp call,
      % which is not allowed in `subsasgn` or `subsref`.
      utils.error('rhsmodel', ...
         'Invalid subscripted assignment to rhsmodel object.');
   end   
   if any(assignpos)
      varargout{1} = this.Assign(1,assignpos,:);
   elseif any(stdcorrpos)
      varargout{1} = this.stdcorr(1,stdcorrpos,:);
   else
      utils.error('rhsmodel', ...
         'This name does not exist in the rhsmodel object: ''%s''.', ...
         name);
   end
   varargout{1} = varargout{1}(:).';
   s(1) = [];
end

if ~isempty(s)
   varargout{1} = subsref(this,s);
end

end