classdef rhsmodel < metaobj & userdataobj & estimateobj
% rhsmodel  Non-linear backward-looking model (rhsmodel) objects and functions.
%
% NOT DOCUMENTED YET.
%

% rhsmodel methods:
%
% Constructor
% ============
%
% * rhsmodel - Non-linear backward-looking model (rhsmodel) objects and functions.
%
% Getting on-line help on model functions
% ========================================
%
%     help rhsmodel
%     help rhsmodel/function_name
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

   properties
      eqtnUsr = {};
      eqtnlabel = {};
      eqtnEval = {};
      eqtnall = [];
      dimplicit = {};
      occur = false(0);
      isident = false(0);
      systemid = [];
      systemkeep = [];
      systemlog = [];
      systempos = [];
      systemj = [];
   end
      
   methods
      function this = rhsmodel(varargin)
         if nargin == 0
            return
         end
         if nargin >= 1 && ischar(varargin{1})
            fname = varargin{1};
            varargin(1) = [];
            opt = passvalopt('rhsmodel.rhsmodel',varargin{:});
            p = preparser(fname,'assign',opt.assign,'saveas',opt.saveas);
            [this,a] = parse(this,p,opt.assign,opt.std);
            this.Export = p.Export;
            export(this);
            this = eqtn2func(this);
            this = assign(this,a);
         end
      end
      
      varargout = alter(varargin)
      varargout = assign(varargin)
      varargout = db2dp(varargin)
      varargout = dp2db(varargin)
      varargout = estimate(varargin)
      varargout = filter(varargin)
      varargout = get(varargin)
      varargout = isempty(varargin)
      varargout = length(varargin)
      varargout = parse(varargin)
      varargout = prediction(varargin)
      varargout = residuals(varargin)
      varargout = simulate(varargin)
      varargout = size(varargin)
   end
   
   methods (Hidden)
      varargout = and(varargin)
      varargout = end(varargin)
      varargout = fieldnames(varargin)
      varargout = myanchors(varargin)
      varargout = horzcat(varargin)
      varargout = kalman(varargin)
      varargout = system(varargin)
      varargout = eqtn2func(varargin)
      varargout = findoccur(varargin)
      varargout = specget(varargin)
   end
   
   methods % (Access=protected,Hidden)
      varargout = objfunc(varargin)
   end
   
   methods (Static)
       varargout = optimset(varargin)
   end
   
end