function d = dp2db(this,A,X,range)

    ny = sum(this.nametype == 1);
    
    for i = 1 : ny
        a = A(i,:,:);
        if this.log(i)
            a = exp(a);
        end
        X(i,:,:) = a;
    end
    
    d = struct();
    template = tseries();
    template.start = range(1);
    for i = find(this.nametype <= 3)
        d.(this.name{i}) = template;
        d.(this.name{i}).data = permute(X(i,:,:),[2,3,1]);
        datasize2 = size(d.(this.name{i}).data,2);
        datasize3 = size(d.(this.name{i}).data,3);
        comment = cell([1,datasize2,datasize3]);
        comment(:) = this.namelabel(i);
        d.(this.name{i}).Comment = comment;
        d.(this.name{i}) = mytrim(d.(this.name{i}));
    end
    for i = find(this.nametype == 4)
        d.(this.name{i}) = permute(this.Assign(1,i,:),[1,3,2]);
    end

end